/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.insights.detectors;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.StatisticStatus;
import com.ibm.bi.predict.explore.ChartInsightsContext;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Operation;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.detectors.InsightsDetector;
import com.ibm.bi.predict.explore.nlt.insights.operations.OverallCountOperation;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class OverallCountDetector
extends InsightsDetector {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(OverallCountDetector.class);

    @Override
    public List<Operation<ChartInsight>> detectOperation(Request request) {
        List<Operation<ChartInsight>> result;
        ChartInsightsContext params;
        if (!request.has(DataAccessProvider.class)) {
            return NONE;
        }
        MetaData metadata = request.get(DataAccessProvider.class).getMetaData();
        List<Integer> expFields = this.getExplanatoryIndexes(metadata, params = request.get(ChartInsightsContext.class));
        Optional explanatoryField = expFields.size() == 1 ? Optional.of(expFields.get(0)) : Optional.empty();
        IntStream suitableFieldIndices = IntStream.range(0, metadata.fieldCount()).filter(idx -> this.isSuitableResponseField(idx, metadata));
        if (metadata.rowCount() < 2) {
            suitableFieldIndices = suitableFieldIndices.filter(idx -> this.originalAggregation(request, metadata.getFieldIdentifier(idx)) != AggregationType.COUNT);
        }
        if (!(result = suitableFieldIndices.mapToObj(idx -> new OverallCountOperation(request, idx, explanatoryField)).collect(Collectors.toList())).isEmpty()) {
            LOGGER.debug("Detected overall count operation");
        }
        return result;
    }

    @Override
    protected boolean isSuitableResponseField(int idx, MetaData metaData) {
        return metaData.getStatisticStatus("rowCount", idx) == StatisticStatus.AVAILABLE;
    }
}

