/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.insights.operations;

import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.InsightSemantics;
import com.ibm.bi.predict.explore.nlt.insights.OperationType;
import com.ibm.bi.predict.explore.nlt.insights.operations.XByExplanatoryOperation;
import com.ibm.bi.predict.explore.nlt.provider.TextProvider;
import com.ibm.bi.predict.math.NumberFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class CountByExplanatoryOperation
extends XByExplanatoryOperation {
    public static final String INSIGHT_COUNT_BY_EXPLANATORY = "INSIGHT_COUNT_BY_EXPLANATORY";
    public static final String COUNT_BY_EXPLANATORY_WITH_PERCENT = "COUNT_BY_EXPLANATORY_WITH_PERCENT";

    public CountByExplanatoryOperation(Request request, List<Integer> explanatoryFieldIndices, int responseFieldIndex) {
        super(request, explanatoryFieldIndices, responseFieldIndex);
    }

    @Override
    protected InsightSemantics makeSemantics() {
        return CountByExplanatoryOperation.makeSemanticsUsingIndices(this.request, OperationType.AGGREGATION_COUNT, this.responseIndex, this.explanatoryFieldIndices);
    }

    @Override
    double getResponseValue(DataRow row) {
        return this.rowCount(row);
    }

    @Override
    public List<ChartInsight> getResults() {
        TextProvider textProvider = this.request.get(TextProvider.class);
        ArrayList<ChartInsight> chartInsightList = new ArrayList<ChartInsight>();
        this.listForTextGeneration.forEach(countByExplanatoryField -> {
            List<String> cats = countByExplanatoryField.getNCategoryLabels();
            if (!cats.isEmpty()) {
                List<List<?>> lists = this.makeMessageLists(cats, (XByExplanatoryOperation.XByExplanatoryField)countByExplanatoryField);
                InsightSemantics semantics = this.semantics().withCategories(cats);
                ChartInsight insight = textProvider.humanizeWithLists(this.request, INSIGHT_COUNT_BY_EXPLANATORY, COUNT_BY_EXPLANATORY_WITH_PERCENT, lists, new Object[]{this.fieldLabel(countByExplanatoryField.getExplanatoryIndex()), countByExplanatoryField.getSumOfN(), this.asPercent(countByExplanatoryField.getPercentageOfN())}, semantics);
                chartInsightList.add(insight);
            }
        });
        return chartInsightList;
    }

    private List<List<?>> makeMessageLists(List<String> cats, XByExplanatoryOperation.XByExplanatoryField countByExplanatoryField) {
        List<List<?>> lists;
        if (cats.size() == 1) {
            lists = Arrays.asList(cats);
        } else {
            List percentages = countByExplanatoryField.getNCategoryPercentages().stream().map(this::asPercent).collect(Collectors.toList());
            lists = Arrays.asList(cats, percentages);
        }
        return lists;
    }

    private String asPercent(double v) {
        return NumberFormatter.formatAsPercent((Locale)this.locale, (double)v);
    }
}

