/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.insights.operations;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.StatisticStatus;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Operation;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.InsightSemantics;
import com.ibm.bi.predict.explore.nlt.insights.OperationType;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class InsightsOperation
extends Operation<ChartInsight> {
    protected final MetaData meta;
    protected final Locale locale;
    protected final int responseIndex;
    protected final String responseLabel;
    private final boolean hasRowCount;
    private InsightSemantics semantics;

    protected InsightsOperation(Request request, int responseIndex, boolean needsDataAccess) {
        super(request);
        this.meta = request.getOpt(DataAccessProvider.class).map(DataAccessProvider::getMetaData).orElse(null);
        if (needsDataAccess && this.meta == null) {
            throw new IllegalStateException("This InsightsOperation needs to access data");
        }
        this.locale = request.getOpt(Locale.class).orElseThrow(() -> new IllegalArgumentException("Locale is required"));
        this.responseIndex = responseIndex;
        this.responseLabel = responseIndex >= 0 ? this.fieldLabel(responseIndex) : null;
        this.hasRowCount = needsDataAccess && responseIndex >= 0 && this.meta.getStatisticStatus("rowCount", responseIndex) == StatisticStatus.AVAILABLE;
    }

    public final InsightSemantics semantics() {
        if (this.semantics == null) {
            this.semantics = this.makeSemantics();
            this.validateSemantics();
        }
        return this.semantics;
    }

    public double rowCount(DataRow row) {
        return this.hasRowCount ? row.getStatistic("rowCount", this.responseIndex) : 1.0;
    }

    private void validateSemantics() {
        if (this.semantics == null) {
            throw new IllegalStateException("Each InsightsOperation must define semantics");
        }
        this.request.getOpt(DataAccessProvider.class).map(DataAccessProvider::getMetaData).ifPresent(metaData -> {
            Set fieldIDs = IntStream.range(0, metaData.fieldCount()).mapToObj(arg_0 -> ((MetaData)metaData).getFieldIdentifier(arg_0)).collect(Collectors.toSet());
            if (this.semantics.responseField() != null && !fieldIDs.contains(this.semantics.responseField())) {
                throw new IllegalStateException("Semantics response was not found in the request");
            }
            if (!fieldIDs.containsAll(this.semantics.fieldsUsedInCalculation())) {
                throw new IllegalStateException("Semantics calculation fields were not all found in the request");
            }
            if (!fieldIDs.containsAll(this.semantics.fieldsUsedInDescription())) {
                throw new IllegalStateException("Semantics description fields were not all found in the request");
            }
        });
    }

    protected abstract InsightSemantics makeSemantics();

    protected static InsightSemantics makeSemanticsUsingIndices(Request request, OperationType func, int response, List<Integer> used, List<Integer> descr) {
        MetaData meta = request.get(DataAccessProvider.class).getMetaData();
        String responseID = meta.getFieldIdentifier(response);
        String[] usedIDs = (String[])used.stream().map(arg_0 -> ((MetaData)meta).getFieldIdentifier(arg_0)).toArray(String[]::new);
        String[] describedIDs = (String[])descr.stream().map(arg_0 -> ((MetaData)meta).getFieldIdentifier(arg_0)).toArray(String[]::new);
        return InsightSemantics.makeFor(func, responseID, usedIDs, describedIDs);
    }

    protected static InsightSemantics makeSemanticsUsingIndices(Request request, OperationType func, int response, List<Integer> used) {
        return InsightsOperation.makeSemanticsUsingIndices(request, func, response, used, Collections.emptyList());
    }

    protected String fieldLabel(int fieldIndex) {
        return this.meta.getFieldDisplayLabel(fieldIndex);
    }

    protected List<String> fieldLabels(List<Integer> fieldIndices) {
        return fieldIndices.stream().map(this::fieldLabel).collect(Collectors.toList());
    }

    protected String fieldIdentifier(int fieldIndex) {
        return this.meta.getFieldIdentifier(fieldIndex);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.semantics() + "]";
    }
}

