/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.insights.operations;

import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.InsightSemantics;
import com.ibm.bi.predict.explore.nlt.insights.OperationType;
import com.ibm.bi.predict.explore.nlt.insights.operations.InsightsOperation;
import com.ibm.bi.predict.explore.nlt.provider.TextProvider;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class OverallAverageOperation
extends InsightsOperation {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(OverallAverageOperation.class);
    final boolean isAggregationAverage;
    final List<Integer> explanatoryFieldIndexes;
    private double sum;
    private double count;
    private double average;
    private boolean hasAverage;
    public static final String INSIGHT_OVERALL_AVERAGE = "INSIGHT_OVERALL_AVERAGE";
    private static final String OVERALL_AVERAGE = "OVERALL_AVERAGE";

    public OverallAverageOperation(Request request, List<Integer> explanatoryFieldIndexes, int responseIndex, boolean isAggregationAverage) {
        super(request, responseIndex, true);
        this.explanatoryFieldIndexes = explanatoryFieldIndexes;
        this.isAggregationAverage = isAggregationAverage;
    }

    @Override
    protected InsightSemantics makeSemantics() {
        return OverallAverageOperation.makeSemanticsUsingIndices(this.request, OperationType.AGGREGATION_AVERAGE, this.responseIndex, Collections.emptyList(), this.explanatoryFieldIndexes);
    }

    Optional<Double> getAverage() {
        return this.hasAverage ? Optional.of(this.average) : Optional.empty();
    }

    public InsightsOperation preUpdate() {
        this.sum = 0.0;
        this.count = 0.0;
        this.hasAverage = false;
        return this;
    }

    public InsightsOperation update(DataRow row) {
        double responseValue;
        double rowCount;
        try {
            rowCount = this.rowCount(row);
        }
        catch (Exception e) {
            LOGGER.debug("Exception getting rowCount statistic", (Throwable)e);
            return this;
        }
        try {
            responseValue = row.getValue(this.responseIndex);
        }
        catch (Exception e) {
            LOGGER.debug("Exception getting value:", (Throwable)e);
            return this;
        }
        if (!Double.isNaN(responseValue) && !Double.isNaN(rowCount)) {
            this.count += rowCount;
            this.hasAverage = true;
            this.sum += this.isAggregationAverage ? rowCount * responseValue : responseValue;
        }
        return this;
    }

    public InsightsOperation postUpdate() {
        if (this.hasAverage()) {
            this.average = this.getSum() / this.getCount();
        }
        return this;
    }

    @Override
    public List<ChartInsight> getResults() {
        if (this.hasAverage()) {
            TextProvider textProvider = this.request.get(TextProvider.class);
            List<String> explanatoryFieldLabels = this.fieldLabels(this.explanatoryFieldIndexes);
            return Collections.singletonList(textProvider.humanizeWithList(this.request, INSIGHT_OVERALL_AVERAGE, OVERALL_AVERAGE, explanatoryFieldLabels, new Object[]{this.average, this.responseLabel}, this.semantics()));
        }
        return Collections.emptyList();
    }

    public double getSum() {
        return this.sum;
    }

    public double getCount() {
        return this.count;
    }

    public boolean hasAverage() {
        return this.hasAverage;
    }
}

