/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.insights.operations;

import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.InsightSemantics;
import com.ibm.bi.predict.explore.nlt.insights.OperationType;
import com.ibm.bi.predict.explore.nlt.insights.operations.InsightsOperation;
import com.ibm.bi.predict.explore.nlt.provider.TextProvider;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class OverallCountOperation
extends InsightsOperation {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(OverallCountOperation.class);
    public static final String INSIGHT_OVERALL_COUNT = "INSIGHT_OVERALL_COUNT";
    public static final String OVERALL_COUNT = "OVERALL_COUNT";
    public static final String OVERALL_COUNT_WITH_EXPLANATORY = "OVERALL_COUNT_WITH_EXPLANATORY";
    private final Optional<Integer> explanatoryField;
    double sum;
    boolean haveSum;

    public OverallCountOperation(Request request, int index, Optional<Integer> explanatoryField) {
        super(request, index, true);
        this.explanatoryField = explanatoryField;
        this.sum = 0.0;
        this.haveSum = false;
    }

    @Override
    protected InsightSemantics makeSemantics() {
        String[] description = this.explanatoryField.map(e -> new String[]{this.meta.getFieldIdentifier(e.intValue())}).orElse(new String[0]);
        return InsightSemantics.makeFor(OperationType.AGGREGATION_COUNT, this.fieldIdentifier(this.responseIndex), new String[0], description);
    }

    public int getIndex() {
        return this.responseIndex;
    }

    public Optional<String> getExplanatoryField() {
        return this.explanatoryField.map(this::fieldIdentifier);
    }

    public InsightsOperation preUpdate() {
        this.sum = 0.0;
        this.haveSum = false;
        return this;
    }

    public InsightsOperation update(DataRow row) {
        try {
            double v = this.rowCount(row);
            if (!Double.isNaN(v)) {
                this.sum += v;
                this.haveSum = true;
            }
        }
        catch (Exception e) {
            LOGGER.debug("Exception getting rowCount statistic", (Throwable)e);
        }
        return this;
    }

    @Override
    public List<ChartInsight> getResults() {
        if (this.haveSum) {
            TextProvider textProvider = this.request.get(TextProvider.class);
            if (this.explanatoryField.isPresent()) {
                String explanatoryLabel = this.fieldLabel(this.explanatoryField.get());
                return Collections.singletonList(textProvider.humanize(this.request, INSIGHT_OVERALL_COUNT, OVERALL_COUNT_WITH_EXPLANATORY, new Object[]{this.sum, this.responseLabel, explanatoryLabel}, this.semantics()));
            }
            return Collections.singletonList(textProvider.humanize(this.request, INSIGHT_OVERALL_COUNT, OVERALL_COUNT, new Object[]{this.sum, this.responseLabel}, this.semantics()));
        }
        return Collections.emptyList();
    }
}

