/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.insights.operations;

import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.InsightSemantics;
import com.ibm.bi.predict.explore.nlt.insights.OperationType;
import com.ibm.bi.predict.explore.nlt.insights.operations.InsightsOperation;
import com.ibm.bi.predict.explore.nlt.provider.TextProvider;
import com.ibm.bi.predict.math.NumericUtils;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Collections;
import java.util.List;

public class OverallSumOperation
extends InsightsOperation {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(OverallSumOperation.class);
    private final boolean isAverage;
    private final List<Integer> explanatoryFieldIndexes;
    private double sum;
    private boolean haveSum;
    public static final String INSIGHT_OVERALL_SUM = "INSIGHT_OVERALL_SUM";
    public static final String OVERALL_SUM = "OVERALL_SUM";

    public OverallSumOperation(Request request, List<Integer> explanatoryFieldIndexes, int responseIndex, boolean isAverage) {
        super(request, responseIndex, true);
        this.explanatoryFieldIndexes = explanatoryFieldIndexes;
        this.isAverage = isAverage;
    }

    @Override
    protected InsightSemantics makeSemantics() {
        return OverallSumOperation.makeSemanticsUsingIndices(this.request, OperationType.AGGREGATION_SUM, this.responseIndex, Collections.emptyList(), this.explanatoryFieldIndexes);
    }

    public InsightsOperation preUpdate() {
        this.sum = 0.0;
        this.haveSum = false;
        return this;
    }

    public InsightsOperation update(DataRow row) {
        try {
            double responseValue = row.getValue(this.responseIndex);
            double rowCount = this.rowCount(row);
            if (!NumericUtils.isMissingValue((double)responseValue) && !NumericUtils.isMissingValue((double)rowCount)) {
                this.sum += this.isAverage ? rowCount * responseValue : responseValue;
                this.haveSum = true;
            }
        }
        catch (Exception e) {
            LOGGER.debug("Exception getting value or rowCount statistic", (Throwable)e);
        }
        return this;
    }

    @Override
    public List<ChartInsight> getResults() {
        if (this.haveSum) {
            TextProvider textProvider = this.request.get(TextProvider.class);
            List<String> explanatoryFieldLabels = this.fieldLabels(this.explanatoryFieldIndexes);
            return Collections.singletonList(textProvider.humanizeWithList(this.request, INSIGHT_OVERALL_SUM, OVERALL_SUM, explanatoryFieldLabels, new Object[]{this.sum, this.responseLabel}, this.semantics()));
        }
        return Collections.emptyList();
    }

    public double sum() {
        return this.sum;
    }
}

