/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.insights.operations;

import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.InsightSemantics;
import com.ibm.bi.predict.explore.nlt.insights.OperationType;
import com.ibm.bi.predict.explore.nlt.insights.operations.XByExplanatoryOperation;
import com.ibm.bi.predict.explore.nlt.provider.TextProvider;
import com.ibm.bi.predict.math.NumberFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class SumByExplanatoryOperation
extends XByExplanatoryOperation {
    private final boolean isAverage;
    public static final String INSIGHT_SUM_BY_EXPLANATORY = "INSIGHT_SUM_BY_EXPLANATORY";
    public static final String SUM_BY_EXPLANATORY = "SUM_BY_EXPLANATORY";

    public SumByExplanatoryOperation(Request request, List<Integer> explanatoryFields, int responseIndex, boolean isAverage) {
        super(request, explanatoryFields, responseIndex);
        this.isAverage = isAverage;
    }

    @Override
    protected InsightSemantics makeSemantics() {
        return SumByExplanatoryOperation.makeSemanticsUsingIndices(this.request, OperationType.AGGREGATION_SUM, this.responseIndex, this.explanatoryFieldIndices);
    }

    @Override
    double getResponseValue(DataRow row) {
        return this.isAverage ? this.rowCount(row) * row.getValue(this.responseIndex) : row.getValue(this.responseIndex);
    }

    @Override
    public List<ChartInsight> getResults() {
        TextProvider textProvider = this.request.get(TextProvider.class);
        ArrayList<ChartInsight> chartInsightList = new ArrayList<ChartInsight>();
        this.listForTextGeneration.forEach(sumByExplanatoryField -> {
            List<String> cats = sumByExplanatoryField.getNCategoryLabels();
            if (!cats.isEmpty()) {
                InsightSemantics semantics = this.semantics().withExplanatoryIndices(Arrays.asList(sumByExplanatoryField.getExplanatoryIndex()), this.meta).withCategories(cats);
                ChartInsight insight = textProvider.humanizeWithList(this.request, INSIGHT_SUM_BY_EXPLANATORY, SUM_BY_EXPLANATORY, cats, new Object[]{this.fieldLabel(sumByExplanatoryField.getExplanatoryIndex()), sumByExplanatoryField.getSumOfN(), NumberFormatter.formatAsPercent((Locale)this.locale, (double)sumByExplanatoryField.getPercentageOfN()), this.responseLabel}, semantics);
                chartInsightList.add(insight);
            }
        });
        return chartInsightList;
    }
}

