/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.insights.postprocessors;

import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Filter;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SpecialCasesFilter
implements Filter<ChartInsight> {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(SpecialCasesFilter.class);
    private static final String LAST_OUTLIER_TYPE = "TIME_SERIES_OUTLIERS_LAST_TIME_POINT_ALERT";
    private static final String ONLY_ONE_OUTLIER_HIGH = "TIME_SERIES_OUTLIERS_ONE_HIGH";
    private static final String ONLY_ONE_OUTLIER_LOW = "TIME_SERIES_OUTLIERS_ONE_LOW";

    @Override
    public List<ChartInsight> filter(List<ChartInsight> input) {
        Stream<ChartInsight> output = input.stream().filter((? super T insight) -> !this.rangeReplacesMax((ChartInsight)insight, input)).filter((? super T insight) -> !this.fitLineReplacesPredictiveStrength((ChartInsight)insight, input)).filter((? super T insight) -> !this.lastPointOutlierReplacesSingleOutlier((ChartInsight)insight, input));
        return output.collect(Collectors.toList());
    }

    private boolean fitLineReplacesPredictiveStrength(ChartInsight target, List<ChartInsight> all) {
        if (!"PREDICTIVE_STRENGTH".equals(target.getType())) {
            return false;
        }
        Optional<ChartInsight> match = all.stream().filter((? super T r) -> "FIT_LINE".equals(r.getType())).filter((? super T r) -> this.sameResponse(target, (ChartInsight)r)).filter((? super T r) -> this.sameExplanatory(target, (ChartInsight)r)).findAny();
        if (match.isPresent()) {
            LOGGER.debug("Removing " + target + " since a fit line operation describes the same info: " + match.get());
            return true;
        }
        return false;
    }

    private boolean rangeReplacesMax(ChartInsight target, List<ChartInsight> all) {
        if (!target.getType().equals("INSIGHT_SUM_BY_EXPLANATORY") || target.semantics().categoriesDefined().size() != 1) {
            return false;
        }
        Set<String> fields = target.semantics().fieldsUsedInCalculation();
        Optional<ChartInsight> match = all.stream().filter((? super T r) -> r.getType().equals("INSIGHT_RANGE")).filter((? super T r) -> this.sameResponse(target, (ChartInsight)r)).filter((? super T r) -> r.semantics().fieldsUsedInDescription().equals(fields)).findAny();
        if (match.isPresent()) {
            LOGGER.debug("Removing " + target + " since a range operation describes the same info: " + match.get());
            return true;
        }
        return false;
    }

    private boolean lastPointOutlierReplacesSingleOutlier(ChartInsight target, List<ChartInsight> all) {
        if (target.getType().equalsIgnoreCase(ONLY_ONE_OUTLIER_HIGH) || target.getType().equalsIgnoreCase(ONLY_ONE_OUTLIER_LOW)) {
            for (ChartInsight test : all) {
                if (!test.getType().equalsIgnoreCase(LAST_OUTLIER_TYPE)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean sameResponse(ChartInsight a, ChartInsight b) {
        return Objects.equals(a.semantics().responseField(), b.semantics().responseField());
    }

    private boolean sameExplanatory(ChartInsight a, ChartInsight b) {
        return a.semantics().fieldsUsedInCalculation().equals(b.semantics().fieldsUsedInCalculation());
    }
}

