/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.math;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.DataIterator;
import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.explore.nlt.math.Range;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class RangeFinder {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(RangeFinder.class);
    final MetaData meta;
    final int valIndex;
    final List<Integer> explanatoryIndexes;
    double min;
    double max;
    Optional<Double> minValue = Optional.empty();
    Optional<Double> maxValue = Optional.empty();
    List<String> minCategories = new ArrayList<String>();
    List<String> maxCategories = new ArrayList<String>();

    public RangeFinder(MetaData meta, int valIndex, List<Integer> explanatoryIndexes) {
        this.meta = meta;
        this.valIndex = valIndex;
        this.explanatoryIndexes = explanatoryIndexes;
        this.preUpdate();
    }

    public void preUpdate() {
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
        this.minValue = Optional.empty();
        this.maxValue = Optional.empty();
        this.minCategories = new ArrayList<String>();
        this.maxCategories = new ArrayList<String>();
    }

    public void update(DataRow row) {
        double v = row.getValue(this.valIndex);
        if (v < this.min) {
            this.min = v;
            this.minCategories = this.getCategoryValues(row, this.explanatoryIndexes, this.meta);
        }
        if (v > this.max) {
            this.max = v;
            this.maxCategories = this.getCategoryValues(row, this.explanatoryIndexes, this.meta);
        }
    }

    public void postUpdate() {
        if (this.min < Double.POSITIVE_INFINITY) {
            this.minValue = Optional.of(this.min);
        }
        if (this.max > Double.NEGATIVE_INFINITY) {
            this.maxValue = Optional.of(this.max);
        }
    }

    public Range getRange() {
        return new Range(this.minValue, this.minCategories, this.maxValue, this.maxCategories);
    }

    public static Range findRange(DataAccessProvider provider, int valIndex, List<Integer> explanatoryIndexes, MetaData meta) {
        RangeFinder finder = new RangeFinder(meta, valIndex, explanatoryIndexes);
        finder.preUpdate();
        DataIterator it = provider.getDataIterator();
        while (it.hasNext()) {
            finder.update((DataRow)it.next());
        }
        finder.postUpdate();
        return finder.getRange();
    }

    private List<String> getCategoryValues(DataRow row, List<Integer> explanatoryIndexes, MetaData meta) {
        return explanatoryIndexes.stream().map(v -> this.getCategoryLabel((int)v, (int)row.getValue(v.intValue()), meta)).collect(Collectors.toList());
    }

    private String getCategoryLabel(int fieldIndex, int value, MetaData meta) {
        try {
            return meta.getFieldCategoryLabel(fieldIndex, value);
        }
        catch (Exception e) {
            LOGGER.debug("Some metadata providers to not support getFieldCategoryLabel, so build one.");
            return meta.getFieldDisplayLabel(fieldIndex) + "_" + value;
        }
    }
}

