/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.math;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.DataIterator;
import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.explore.nlt.math.BasicCalculations;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;

public class Sum
implements BasicCalculations {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(Sum.class);

    @Override
    public double compute(DataAccessProvider accessProvider, Integer index) {
        MetaData meta = accessProvider.getMetaData();
        if (index < 0 || index >= meta.fieldCount()) {
            LOGGER.error("Field index is outside of the range");
            throw new IllegalArgumentException("Field index is outside of the range");
        }
        if (meta.getFieldType(index.intValue()) != FieldType.NUMERICAL) {
            LOGGER.error("Can't compute sum on categorical field");
            throw new UnsupportedOperationException("Can't compute sum on categorical field");
        }
        double result = 0.0;
        DataIterator di = accessProvider.getDataIterator();
        while (di.hasNext()) {
            double value = ((DataRow)di.next()).getValue(index.intValue());
            if (Double.isNaN(value)) continue;
            result += value;
        }
        return result;
    }
}

