/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.provider;

import com.ibm.bi.predict.explore.Tag;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.InsightSemantics;
import com.ibm.bi.predict.messages.Messages;
import com.ibm.bi.predict.messages.NoValueReplacement;
import com.ibm.bi.predict.utils.Tuple;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONObject;

public class TextProvider {
    private final Locale locale;
    private final Messages messages;
    private final String noValue;
    private static final String NO_VALUE_KEY = "NO_VALUE";

    public TextProvider(Locale locale) {
        this.locale = locale;
        this.messages = Messages.getMessagesFor((String)"Predict_Insights", (Locale)locale);
        this.noValue = this.messages.get(NO_VALUE_KEY, new Object[0]);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ChartInsight humanize(Request params, String type, String messageKey, Object[] args, InsightSemantics semantics) {
        return new ChartInsight(params, this.humanize(messageKey, args), new JSONObject(), Tag.getTags(type), type, semantics);
    }

    public ChartInsight humanizeWithList(Request params, String type, String messageKey, List<?> list, Object[] args, InsightSemantics semantics) {
        return new ChartInsight(params, this.humanizeWithList(messageKey, list, args), new JSONObject(), Tag.getTags(type), type, semantics);
    }

    public ChartInsight humanizeWithLists(Request params, String type, String messageKey, List<List<?>> lists, Object[] args, InsightSemantics semantics) {
        return new ChartInsight(params, this.humanizeWithLists(messageKey, lists, args), new JSONObject(), Tag.getTags(type), type, semantics);
    }

    public String humanize(String messageKey, Object ... args) {
        Object[] finalArgs = this.formatArgs(args);
        return this.messages.get(messageKey, finalArgs);
    }

    public String humanizeWithList(String baseMessageKey, List<? extends Object> list, Object ... args) {
        int i;
        Tuple<String, Integer> listInfo = this.getHumanizeWithListInfo(baseMessageKey, list.size());
        int listArgsUsed = (Integer)listInfo._2;
        Object[] newArgs = new Object[args.length + listArgsUsed];
        for (i = 0; i < args.length; ++i) {
            newArgs[i] = args[i];
        }
        for (i = 0; i < listArgsUsed; ++i) {
            newArgs[i + args.length] = list.get(i);
        }
        return this.humanize((String)listInfo._1, newArgs);
    }

    public String humanizeWithLists(String baseMessageKey, List<List<? extends Object>> lists, Object ... args) {
        int numLists = lists.size();
        if (numLists == 0) {
            return this.humanizeWithList(baseMessageKey, Collections.emptyList(), args);
        }
        if (numLists == 1) {
            return this.humanizeWithList(baseMessageKey, lists.get(0), args);
        }
        Tuple<String, Integer> listInfo = this.getHumanizeWithListInfo(baseMessageKey, lists.get(0).size());
        int listArgsUsed = (Integer)listInfo._2;
        Object[] newArgs = new Object[args.length + numLists * listArgsUsed];
        for (int i = 0; i < args.length; ++i) {
            newArgs[i] = args[i];
        }
        int ct = args.length;
        for (int i = 0; i < listArgsUsed; ++i) {
            for (int lnum = 0; lnum < numLists; ++lnum) {
                newArgs[ct++] = lists.get(lnum).get(i);
            }
        }
        return this.humanize((String)listInfo._1, newArgs);
    }

    private Tuple<String, Integer> getHumanizeWithListInfo(String baseMessageKey, int listLength) {
        int maxListArgs = Integer.parseInt(this.getConstant(baseMessageKey + "_MAXARGS"));
        if (listLength > maxListArgs) {
            return new Tuple((Object)(baseMessageKey + "_ANDOTHERS"), (Object)maxListArgs);
        }
        return new Tuple((Object)(baseMessageKey + "_" + listLength), (Object)listLength);
    }

    public String getConstant(String key) {
        return this.messages.get(key, new Object[0]);
    }

    public Object[] formatArgs(Object[] args) {
        Object[] finalArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof List) {
                List newList;
                List argsList = (List)args[i];
                finalArgs[i] = newList = argsList.stream().map(obj -> this.replaceSpecialCharacters(obj)).map(obj -> this.replaceEmptyString(obj)).collect(Collectors.toList());
                continue;
            }
            if (args[i] instanceof String) {
                finalArgs[i] = this.replaceSpecialCharacters(args[i]);
                finalArgs[i] = this.replaceEmptyString(finalArgs[i]);
                continue;
            }
            finalArgs[i] = args[i];
        }
        return finalArgs;
    }

    public Object replaceSpecialCharacters(Object obj) {
        if (obj instanceof String) {
            return ((String)obj).replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        }
        return obj;
    }

    public Object replaceEmptyString(Object obj) {
        if (obj instanceof String) {
            return NoValueReplacement.replace((String)((String)obj), (String)this.noValue);
        }
        return obj;
    }
}

