/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.smartannotations;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.explore.ChartInsightsContext;
import com.ibm.bi.predict.sa.suggestion.api.request.AnnotationData;
import com.ibm.bi.predict.sa.suggestion.api.request.AnnotationRequest;
import com.ibm.bi.predict.sa.suggestion.domain.Annotations;
import com.ibm.bi.predict.sa.suggestion.service.AnnotationService;
import com.ibm.bi.predict.types.DataItem;
import com.ibm.bi.predict.types.DataItemType;
import com.ibm.bi.predict.types.RoleType;
import com.ibm.bi.predict.types.Slot;
import com.ibm.bi.predict.types.SlotType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;

public class AnnotationServiceCaller {
    private final AnnotationService service;
    private final Locale locale;

    public AnnotationServiceCaller(AnnotationService service, Locale locale) {
        this.service = service;
        this.locale = locale;
    }

    public Annotations run(DataAccessProvider provider, ChartInsightsContext params) {
        return this.service.getSuitableAnnotations(AnnotationServiceCaller.buildRequest(provider, params), this.locale);
    }

    static AnnotationRequest buildRequest(DataAccessProvider provider, ChartInsightsContext params) {
        ArrayList<DataItem> items = new ArrayList<DataItem>();
        ArrayList<Slot> slots = new ArrayList<Slot>();
        MetaData md = provider.getMetaData();
        for (int i = 0; i < md.fieldCount(); ++i) {
            String fieldId = md.getFieldIdentifier(i);
            if (fieldId.contains(":")) continue;
            FieldType type = md.getFieldType(i);
            items.add(AnnotationServiceCaller.makeDataItem(fieldId, fieldId, type, md.getFieldAggregation(i)));
            slots.add(AnnotationServiceCaller.makeSlot(fieldId, type, params.getRole(fieldId)));
        }
        AnnotationRequest request = new AnnotationRequest();
        request.setVersion("0.0.1");
        request.setData(Collections.singletonList(new AnnotationData("a generated ID", items)));
        request.setUse(slots);
        return request;
    }

    private static DataItem makeDataItem(String id, String fieldId, FieldType type, AggregationType agg) {
        DataItem item = new DataItem();
        item.setId(id);
        item.setItemId(fieldId);
        item.setType(AnnotationServiceCaller.dataItemType(type));
        item.setAggregate(agg);
        return item;
    }

    private static DataItemType dataItemType(FieldType fieldType) {
        if (fieldType == FieldType.CATEGORICAL) {
            return DataItemType.CATEGORICAL;
        }
        if (fieldType == FieldType.NUMERICAL) {
            return DataItemType.CONTINUOUS;
        }
        return DataItemType.DATETIME;
    }

    private static Slot makeSlot(String id, FieldType type, RoleType role) {
        Slot slot = new Slot();
        slot.setName(id);
        slot.setDataItems(Collections.singletonList(id));
        slot.setType(type == FieldType.NUMERICAL ? SlotType.CONTINUOUS : SlotType.CATEGORICAL);
        slot.setRole(role);
        return slot;
    }
}

