/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.smartannotations;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.explore.data.CoefficientsFinder;
import com.ibm.bi.predict.explore.data.RecordingDecorator;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.InsightSemantics;
import com.ibm.bi.predict.explore.nlt.insights.OperationType;
import com.ibm.bi.predict.explore.nlt.math.CriticalPoint;
import com.ibm.bi.predict.explore.nlt.math.CriticalPointsFinder;
import com.ibm.bi.predict.explore.nlt.math.Range;
import com.ibm.bi.predict.explore.nlt.math.RangeFinder;
import com.ibm.bi.predict.explore.nlt.provider.TextProvider;
import com.ibm.bi.predict.math.NumericUtils;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.json.JSON;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class DecorationProcessor {
    private final Request params;
    private DataAccessProvider provider;
    private final Range range;
    private static final String EXTREMA_IN_RANGE_MIN = "EXTREMA_IN_RANGE_MIN";
    private static final String EXTREMA_IN_RANGE_MAX = "EXTREMA_IN_RANGE_MAX";
    private static final String EXTREMA_OUT_RANGE_MIN = "EXTREMA_OUT_RANGE_MIN";
    private static final String EXTREMA_OUT_RANGE_MAX = "EXTREMA_OUT_RANGE_MAX";
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(DecorationProcessor.class);

    public DecorationProcessor(Request params, DataAccessProvider provider, int valIndex, List<Integer> explanatoryIndexes, MetaData meta) {
        this.params = params;
        this.provider = provider;
        this.range = RangeFinder.findRange(provider, valIndex, explanatoryIndexes, meta);
    }

    public List<ChartInsight> createChartInsights() throws JSONException {
        RecordingDecorator jd = (RecordingDecorator)this.provider.getDecorator();
        return jd.getCalls().stream().filter(call -> "fitLine".equals(call.key)).flatMap(this::findExtrema).map(this::toChartInsight).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Stream<CriticalPoint> findExtrema(RecordingDecorator.Deco deco) {
        double[] betas = null;
        try {
            betas = CoefficientsFinder.find(deco);
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Finding coefficients as a decoration failed", (Throwable)e);
        }
        if (this.hasSufficientBetas(betas)) {
            String explanatoryName = this.findExplanatoryName(deco);
            return new CriticalPointsFinder().findExtrema(betas, deco.columnIdx, explanatoryName).stream();
        }
        return new ArrayList().stream();
    }

    private String findExplanatoryName(RecordingDecorator.Deco deco) {
        try {
            JSONArray fitArray = (JSONArray)JSON.parse((String)deco.value.toString());
            JSONObject fit = fitArray.getJSONObject(0);
            return fit.getString("explanatoryName");
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("No explanatoryName found", e);
        }
    }

    private boolean hasSufficientBetas(double[] betas) {
        if (betas != null) {
            int lastBeta = 0;
            for (int i = 0; i < betas.length; ++i) {
                if (NumericUtils.equals((double)betas[i], (double)0.0)) continue;
                lastBeta = i;
            }
            return lastBeta >= 2;
        }
        return false;
    }

    private Optional<ChartInsight> toChartInsight(CriticalPoint extrema) {
        String responseName = this.provider.getMetaData().getFieldDisplayLabel(extrema.getFieldIndex());
        String explanatoryName = extrema.getExplanatoryName();
        String msgKey = null;
        if (this.isOutsideRange(extrema).booleanValue() && this.isWithinTwoRanges(extrema).booleanValue()) {
            msgKey = extrema.geteType() == CriticalPoint.CriticalPointType.MIN ? EXTREMA_OUT_RANGE_MIN : EXTREMA_OUT_RANGE_MAX;
        } else if (!this.isOutsideRange(extrema).booleanValue()) {
            String string = msgKey = extrema.geteType() == CriticalPoint.CriticalPointType.MIN ? EXTREMA_IN_RANGE_MIN : EXTREMA_IN_RANGE_MAX;
        }
        if (msgKey != null) {
            AggregationType aggr = extrema.geteType() == CriticalPoint.CriticalPointType.MIN ? AggregationType.MINIMUM : AggregationType.MAXIMUM;
            OperationType type = new OperationType(OperationType.Base.aggregation, aggr);
            InsightSemantics semantics = InsightSemantics.makeFor(type, responseName, new String[]{explanatoryName}, new String[0]);
            return Optional.of(this.params.get(TextProvider.class).humanize(this.params, "INSIGHT_EXTREMA", msgKey, new Object[]{responseName, extrema.getY(), explanatoryName, extrema.getX()}, semantics));
        }
        return Optional.empty();
    }

    private Boolean isOutsideRange(CriticalPoint extrema) {
        return this.range.getMinValue().isPresent() && extrema.getX() < this.range.getMinValue().get() || this.range.getMaxValue().isPresent() && extrema.getX() > this.range.getMaxValue().get();
    }

    private Boolean isWithinTwoRanges(CriticalPoint extrema) {
        if (this.range.getMinValue().isPresent() && this.range.getMaxValue().isPresent()) {
            double diff = this.range.getMaxValue().get() - this.range.getMinValue().get();
            return Math.abs(extrema.getX() - this.range.getMinValue().get()) <= 2.0 * diff || Math.abs(extrema.getX() - this.range.getMaxValue().get()) <= 2.0 * diff;
        }
        return false;
    }
}

