/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.smartannotations;

import com.ibm.bi.predict.algorithms.forecasting.es.ESFit;
import com.ibm.bi.predict.algorithms.forecasting.result.SeriesResult;
import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.explore.Tag;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.InsightSemantics;
import com.ibm.bi.predict.messages.Messages;
import com.ibm.bi.predict.sa.execution.annotation.response.Message;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.json.JSONObject;

public final class TimeSeriesTrendInsights {
    private static final Logger LOG = PredictLoggerFactory.getLogger(TimeSeriesTrendInsights.class);
    private static final String TREND_MSG_PREFIX = "TIME_SERIES_TREND_";

    private TimeSeriesTrendInsights() {
    }

    public static List<ChartInsight> getTrendInsights(SeriesResult sr, Request params, InsightSemantics semantics, Message message) {
        ArrayList<ChartInsight> insights = new ArrayList<ChartInsight>();
        ESFit.TrendDirection trendDir = sr.getESFit().getTrendDirection();
        if (trendDir == ESFit.TrendDirection.NONE) {
            return insights;
        }
        ESFit.TrendStrength trendStr = TimeSeriesTrendInsights.getContributionStrength(sr);
        if (trendStr == ESFit.TrendStrength.NONE) {
            return insights;
        }
        String msg = Messages.getMessagesFor((String)"Predict_Insights", (Locale)TimeSeriesTrendInsights.extractLocale(params)).get(TREND_MSG_PREFIX + trendStr.toString() + "_" + trendDir.toString(), new Object[]{TimeSeriesTrendInsights.getColumnLabel(params)});
        insights.add(new ChartInsight(params, msg, new JSONObject(), Tag.getTags(message.type), message.type, semantics));
        return insights;
    }

    static String getColumnLabel(Request params) {
        MetaData md = params.get(DataAccessProvider.class).getMetaData();
        for (int i = 0; i < md.fieldCount(); ++i) {
            if (md.getFieldType(i) != FieldType.NUMERICAL) continue;
            return md.getFieldDisplayLabel(i);
        }
        return "";
    }

    static ESFit.TrendStrength getContributionStrength(SeriesResult sr) {
        return sr.getESFit().getTrendStrength();
    }

    private static Locale extractLocale(Request params) {
        return params.getOpt(Locale.class).orElse(Locale.getDefault());
    }
}

