/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.relationship;

import com.ibm.bi.predict.explore.ExploreContext;
import com.ibm.bi.predict.explore.ExploreParams;
import com.ibm.bi.predict.explore.relationship.RelationshipStrengthsResult;
import com.ibm.bi.predict.explore.result.ExploreResult;
import com.ibm.bi.predict.explore.result.RelationshipResult;
import com.ibm.bi.predict.explore.result.RelationshipStrength;
import com.ibm.bi.predict.result.ExecutionResult;
import com.ibm.bi.predict.result.Message;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class RelationshipResultSerializer {
    static final String NODESDATASET = "nodesDataset";
    static final String NODESDATASET_TARGETID = "targetId";
    static final String NODESDATASET_GROUPINGS = "groupings";
    static final String GROUPING_ID = "id";
    static final String GROUPING_GROUPS = "groups";
    static final String GROUPING_GROUP_ID = "groupId";
    static final String GROUPING_GROUP_MEMBERS = "members";
    static final String GROUPING_GROUP_MEMBER_ID = "id";
    static final String GROUPING_GROUP_MEMBER_TYPE = "type";
    static final String GROUPING_MEMBER_TYPE_FOCUSFIELD = "focusField";
    static final String RELATIONSHIPSTRENGTH_PREDICTSTATUS = "predictStatus";
    static final String PREDICTSTATUS_STATE = "state";
    static final String PREDICTSTATUS_WARNINGS = "warnings";
    static final String PREDICTSTATUS_ERRORS = "errors";
    static final String NODESDATASET_RELATIONSHIPSTRENGTH = "relationshipStrength";
    static final String RELATIONSHIPSTRENGTH_VERSION = "version";
    static final String RELATIONSHIPSTRENGTH_RESULTS = "results";
    static final String MESSAGE_ID = "id";
    static final String MESSAGE_CAPTION = "caption";
    static final String MESSAGE_COLUMNS = "columns";
    static final String RELATIONSHIPRESULT_ID = "id";
    static final String RELATIONSHIPRESULT_RELATIONSHIPS = "relationships";
    static final String RELATIONSHIPLINK_A = "a";
    static final String RELATIONSHIPLINK_B = "b";
    static final String RELATIONSHIPLINK_STRENGTH = "strength";
    static final String RELATIONSHIPLINK_FIELDA = "fieldA";
    static final String RELATIONSHIPLINK_FIELDB = "fieldB";

    private RelationshipResultSerializer() {
    }

    public static JSONObject getNodesDataset(ExploreResult result) throws JSONException {
        return RelationshipResultSerializer.getNodesDataset(result, result.getContext(), (List)result.getContent());
    }

    public static JSONObject getNodesDataset(RelationshipStrengthsResult result) throws JSONException {
        return RelationshipResultSerializer.getNodesDataset(result, result.getContext(), (List)result.getContent());
    }

    static JSONObject getNodesDataset(ExecutionResult<?> result, ExploreContext context, List<RelationshipResult> content) throws JSONException {
        JSONObject o = new JSONObject();
        JSONObject nodesDataset = new JSONObject();
        o.put(NODESDATASET, (Map)nodesDataset);
        String targetId = context.getString("target", null);
        nodesDataset.put(NODESDATASET_TARGETID, (Object)targetId);
        JSONArray groupings = new JSONArray();
        nodesDataset.put(NODESDATASET_GROUPINGS, (Collection)groupings);
        JSONObject relationshipStrength = new JSONObject();
        o.put(NODESDATASET_RELATIONSHIPSTRENGTH, (Map)relationshipStrength);
        relationshipStrength.put(RELATIONSHIPSTRENGTH_VERSION, (Object)context.getString(RELATIONSHIPSTRENGTH_VERSION, null));
        relationshipStrength.put(RELATIONSHIPSTRENGTH_PREDICTSTATUS, (Map)RelationshipResultSerializer.serializeStatus(result));
        JSONArray results = new JSONArray();
        relationshipStrength.put(RELATIONSHIPSTRENGTH_RESULTS, (Collection)results);
        for (RelationshipResult rr : content) {
            groupings.add((Object)RelationshipResultSerializer.serializeGrouping(rr.getGrouping(), targetId));
            results.add((Object)RelationshipResultSerializer.serializeRelationshipResult(rr.getId(), rr.getRelationships()));
        }
        return o;
    }

    static JSONObject serializeStatus(ExecutionResult<?> result) throws JSONException {
        JSONObject o = new JSONObject();
        o.put(PREDICTSTATUS_STATE, (Object)result.getStatus().toString());
        JSONArray warnings = new JSONArray();
        o.put(PREDICTSTATUS_WARNINGS, (Collection)warnings);
        for (Message m : result.getWarningMessages()) {
            warnings.add((Object)RelationshipResultSerializer.serializeMessage(m));
        }
        JSONArray errors = new JSONArray();
        o.put(PREDICTSTATUS_ERRORS, (Collection)errors);
        for (Message m : result.getErrorMessages()) {
            errors.add((Object)RelationshipResultSerializer.serializeMessage(m));
        }
        return o;
    }

    static JSONObject serializeMessage(Message m) throws JSONException {
        JSONObject o = new JSONObject();
        o.put("id", (Object)m.getMessageCode().toString());
        o.put(MESSAGE_CAPTION, (Object)m.getCaption());
        o.put(MESSAGE_COLUMNS, (Collection)new JSONArray((Collection)m.getColumnIds()));
        return o;
    }

    static JSONObject serializeGrouping(ExploreParams.Grouping grouping, String targetId) throws JSONException {
        JSONObject o = new JSONObject();
        o.put("id", (Object)grouping.getId());
        JSONArray groups = new JSONArray();
        o.put(GROUPING_GROUPS, (Collection)groups);
        for (ExploreParams.Group group : grouping.getGroups()) {
            JSONObject jg = new JSONObject();
            groups.add((Object)jg);
            jg.put(GROUPING_GROUP_ID, (Object)group.getId());
            JSONArray members = new JSONArray();
            jg.put(GROUPING_GROUP_MEMBERS, (Collection)members);
            for (String m : group.getMembers()) {
                if (m == null) continue;
                JSONObject jm = new JSONObject();
                jm.put("id", (Object)m);
                if (m.equals(targetId)) {
                    jm.put(GROUPING_GROUP_MEMBER_TYPE, (Object)GROUPING_MEMBER_TYPE_FOCUSFIELD);
                }
                members.add((Object)jm);
            }
        }
        return o;
    }

    static JSONObject serializeRelationshipResult(String id, List<RelationshipStrength> strengths) throws JSONException {
        JSONObject o = new JSONObject();
        o.put("id", (Object)id);
        JSONArray relationships = new JSONArray();
        o.put(RELATIONSHIPRESULT_RELATIONSHIPS, (Collection)relationships);
        for (RelationshipStrength rs : strengths) {
            JSONObject r = new JSONObject();
            relationships.add((Object)r);
            r.put(RELATIONSHIPLINK_A, (Object)rs.getA());
            r.put(RELATIONSHIPLINK_B, (Object)rs.getB());
            r.put(RELATIONSHIPLINK_STRENGTH, rs.getStrength());
            r.put(RELATIONSHIPLINK_FIELDA, (Object)rs.getFieldA());
            r.put(RELATIONSHIPLINK_FIELDB, (Object)rs.getFieldB());
        }
        return o;
    }
}

