/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.service;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.exceptions.PredictException;
import com.ibm.bi.predict.explore.ExploreContext;
import com.ibm.bi.predict.explore.ExploreService;
import com.ibm.bi.predict.explore.result.ExploreResult;
import com.ibm.bi.predict.explore.service.RelationshipsContext;
import com.ibm.bi.predict.result.StatusCode;
import com.ibm.bi.predict.service.PredictServiceFramework;
import com.ibm.bi.predict.service.PredictServiceRequest;
import com.ibm.bi.predict.service.PredictServiceResponse;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class RelationshipsService
implements PredictServiceFramework {
    private static final Logger logger = PredictLoggerFactory.getLogger(RelationshipsService.class);
    private final ExploreService exploreService;

    public RelationshipsService() {
        this(ExploreService.getService());
    }

    public RelationshipsService(ExploreService exploreService) {
        this.exploreService = exploreService;
    }

    public PredictServiceResponse run(Collection<PredictServiceRequest> requests, Locale locale) {
        if (requests.isEmpty()) {
            logger.warn("Received an empty request set");
            return new ExploreResult(StatusCode.SUCCESS, Collections.emptyList(), new ExploreContext());
        }
        PredictServiceRequest request = requests.iterator().next();
        return this.handleRequest(request);
    }

    private ExploreResult handleRequest(PredictServiceRequest request) {
        return this.runExplorations(request.getData().asDataAccessProvider(), request);
    }

    private ExploreResult runExplorations(DataAccessProvider data, PredictServiceRequest request) {
        JSONObject params = this.makeRelationshipsParams(data.getMetaData(), request);
        return this.exploreService.runAlgorithms(data, params);
    }

    private JSONObject makeRelationshipsParams(MetaData metaData, PredictServiceRequest request) {
        try {
            JSONObject params = new JSONObject();
            RelationshipsContext context = (RelationshipsContext)request.getContext();
            List candidatesIds = context.getCandidates().stream().map(c -> c.id()).collect(Collectors.toList());
            params.put("version", (Object)"1.0.2");
            params.put("candidates", candidatesIds);
            params.put("target", (Object)context.getTarget().id());
            params.put("locale", (Object)"");
            params.put("requestedItemCount", 0);
            params.put("groupings", (Collection)context.getGroupings());
            params.put("sampledData", true);
            return params;
        }
        catch (JSONException e) {
            logger.warn("Failed to create JSON parameters for relationships service call. Reason: " + e.getMessage(), (Throwable)e);
            throw new PredictException("Failed to create JSON parameters for relationships service call. Reason: " + e.getMessage(), (Throwable)e);
        }
    }
}

