/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.visrecommender.rules;

import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.types.Binning;
import com.ibm.bi.predict.types.DataItem;
import com.ibm.bi.predict.utils.JsonUtils;
import java.util.List;
import org.apache.commons.json.JSONObject;

public class VisRecommenderItem {
    static final String ITEMID_KEY = "itemId";
    static final String BINNING_KEY = "binning";
    static final String AGGREGATE_KEY = "aggregate";
    static final String SORT_KEY = "sort";
    final String itemId;
    final Binning binning;
    final String aggregate;
    final boolean sort;

    VisRecommenderItem(String itemId, Binning binning, String aggregate, boolean sort) {
        this.itemId = itemId;
        this.binning = binning;
        this.aggregate = aggregate;
        this.sort = sort;
    }

    DataItem createDataItem(int slotIndex, int itemIndex, DataColumn.ColumnMeta target, List<DataColumn.ColumnMeta> drivers) {
        String id = "id_" + slotIndex + "_" + itemIndex;
        String realItemId = this.getItemId(target, drivers);
        AggregationType realAggregate = this.getAggregate(target, drivers);
        DataItem item = new DataItem();
        item.setId(id);
        item.setItemId(realItemId);
        item.setBinning(this.binning);
        item.setAggregate(realAggregate);
        item.setSort(this.sort);
        return item;
    }

    String getItemId(DataColumn.ColumnMeta target, List<DataColumn.ColumnMeta> drivers) {
        DataColumn.ColumnMeta meta = VisRecommenderItem.getMeta(this.itemId, target, drivers);
        if (meta != null) {
            return meta.getId();
        }
        return this.itemId;
    }

    AggregationType getAggregate(DataColumn.ColumnMeta target, List<DataColumn.ColumnMeta> drivers) {
        DataColumn.ColumnMeta meta = VisRecommenderItem.getMeta(this.aggregate, target, drivers);
        if (meta != null) {
            return meta.getAggregationType();
        }
        return AggregationType.fromString((String)this.aggregate);
    }

    static DataColumn.ColumnMeta getMeta(String value, DataColumn.ColumnMeta target, List<DataColumn.ColumnMeta> drivers) {
        if (value == null) {
            return null;
        }
        if ("#TARGET".equals(value)) {
            return target;
        }
        if ("#DRIVER_0".equals(value)) {
            return drivers.size() > 0 ? drivers.get(0) : null;
        }
        if ("#DRIVER_1".equals(value)) {
            return drivers.size() > 1 ? drivers.get(1) : null;
        }
        if (value.startsWith("#DRIVER_")) {
            int ix = Integer.parseInt(value.substring(8));
            return drivers.size() > ix ? drivers.get(ix) : null;
        }
        return null;
    }

    static VisRecommenderItem fromJSON(JSONObject obj) {
        try {
            String itemId = JsonUtils.getRequiredString((JSONObject)obj, (String)ITEMID_KEY);
            Binning binning = Binning.fromString((String)JsonUtils.getOptionalString((JSONObject)obj, (String)BINNING_KEY, (String)"none"));
            String aggregate = JsonUtils.getOptionalString((JSONObject)obj, (String)AGGREGATE_KEY);
            boolean sort = JsonUtils.getOptionalBoolean((JSONObject)obj, (String)SORT_KEY, (boolean)false);
            return new VisRecommenderItem(itemId, binning, aggregate, sort);
        }
        catch (Exception e) {
            throw new BadParametersException("Parsing rule assignment: " + e.getMessage(), (Throwable)e);
        }
    }
}

