/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.visrecommender.rules;

import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.utils.JsonUtils;
import org.apache.commons.json.JSONObject;

public class VisRecommenderMetadata {
    static final String FIELDTYPE_KEY = "fieldType";
    static final String AGGREGATE_KEY = "aggregate";
    final String fieldType;
    final String aggregate;

    VisRecommenderMetadata(String fieldType, String aggregate) {
        this.fieldType = fieldType;
        this.aggregate = aggregate;
    }

    boolean matches(DataColumn.ColumnMeta meta) {
        return this.fieldMatches(meta.getType()) && this.aggregateMatches(meta.getAggregationType());
    }

    private boolean fieldMatches(FieldType t) {
        return t != null && (this.fieldType == null || this.fieldType.equalsIgnoreCase(t.toString()));
    }

    private boolean aggregateMatches(AggregationType t) {
        return t != null && (this.aggregate == null || this.aggregate.equalsIgnoreCase(t.toString()) || t == AggregationType.NONE && "none".equalsIgnoreCase(this.aggregate));
    }

    static VisRecommenderMetadata fromJSON(JSONObject obj) {
        String fieldType = JsonUtils.getOptionalString((JSONObject)obj, (String)FIELDTYPE_KEY);
        String aggregate = JsonUtils.getOptionalString((JSONObject)obj, (String)AGGREGATE_KEY);
        return new VisRecommenderMetadata(fieldType, aggregate);
    }
}

