/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.visrecommender.rules;

import com.ibm.bi.predict.explore.visrecommender.rules.VisRecommenderRuleset;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.json.JSONObject;

public class VisRecommenderResource {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(VisRecommenderResource.class);
    private static final String RESOURCE_NAME = "visrecommender.json";
    private static final String DEVELOPMENT_FILENAME = "/tmp/visrecommender.json";
    private static final VisRecommenderRuleset rules = VisRecommenderResource.loadFromResource("visrecommender.json");
    static boolean useDevelopmentFile = false;

    private VisRecommenderResource() {
    }

    public static VisRecommenderRuleset getRules() {
        if (useDevelopmentFile) {
            return VisRecommenderResource.loadFromDevelopmentFile(DEVELOPMENT_FILENAME);
        }
        return rules;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static VisRecommenderRuleset loadFromResource(String resource) {
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);){
            VisRecommenderRuleset visRecommenderRuleset = VisRecommenderResource.loadFromStream(stream);
            return visRecommenderRuleset;
        }
        catch (Exception e) {
            LOGGER.error("Rule resource '" + resource + "' not loaded, using empty ruleset", (Throwable)e);
            return new VisRecommenderRuleset();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static VisRecommenderRuleset loadFromDevelopmentFile(String filename) {
        try (FileInputStream stream = new FileInputStream(new File(filename));){
            VisRecommenderRuleset visRecommenderRuleset = VisRecommenderResource.loadFromStream(stream);
            return visRecommenderRuleset;
        }
        catch (Exception e) {
            LOGGER.error("Rule file '" + filename + "' not loaded, using resource", (Throwable)e);
            return rules;
        }
    }

    private static VisRecommenderRuleset loadFromStream(InputStream stream) throws Exception {
        if (stream == null) {
            throw new FileNotFoundException("File not found");
        }
        JSONObject json = new JSONObject(stream);
        return VisRecommenderRuleset.fromJSON(json);
    }
}

