/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.visrecommender.rules;

import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.explore.visrecommender.VisRecommendation;
import com.ibm.bi.predict.explore.visrecommender.rules.VisRecommenderChart;
import com.ibm.bi.predict.explore.visrecommender.rules.VisRecommenderWhen;
import com.ibm.bi.predict.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONObject;

class VisRecommenderRule {
    static final String NAME_KEY = "name";
    static final String WHEN_KEY = "when";
    static final String RECOMMEND_KEY = "recommend";
    final String name;
    final VisRecommenderWhen when;
    final List<VisRecommenderChart> recommend;

    VisRecommenderRule(String name, VisRecommenderWhen when, List<VisRecommenderChart> recommend) {
        this.name = name;
        this.when = when;
        this.recommend = recommend;
    }

    public String getType() {
        return this.when.type;
    }

    public Optional<List<VisRecommendation>> getRecommendations(String type, DataColumn.ColumnMeta target, List<DataColumn.ColumnMeta> drivers) {
        Optional<List<DataColumn.ColumnMeta>> patternResult = this.when.matches(type, target, drivers);
        if (patternResult.isPresent()) {
            List<DataColumn.ColumnMeta> driverOrder = patternResult.get();
            ArrayList<VisRecommendation> result = new ArrayList<VisRecommendation>();
            for (VisRecommenderChart rec : this.recommend) {
                result.add(rec.createChart(target, driverOrder));
            }
            return Optional.of(result);
        }
        return Optional.empty();
    }

    static VisRecommenderRule fromJSON(JSONObject obj) {
        try {
            String name = JsonUtils.getRequiredString((JSONObject)obj, (String)NAME_KEY);
            VisRecommenderWhen when = VisRecommenderWhen.fromJSON(JsonUtils.getRequiredJSONObject((JSONObject)obj, (String)WHEN_KEY));
            ArrayList<VisRecommenderChart> recommendations = new ArrayList<VisRecommenderChart>();
            JSONArray a = JsonUtils.getRequiredJSONArray((JSONObject)obj, (String)RECOMMEND_KEY);
            for (int i = 0; i < a.size(); ++i) {
                recommendations.add(VisRecommenderChart.fromJSON(JsonUtils.getRequiredJSONObject((JSONArray)a, (int)i, (String)RECOMMEND_KEY)));
            }
            return new VisRecommenderRule(name, when, recommendations);
        }
        catch (Exception e) {
            throw new BadParametersException("Parsing visualization recommendation rule: " + e.getMessage(), (Throwable)e);
        }
    }
}

