/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.visrecommender.rules;

import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.explore.visrecommender.rules.VisRecommenderItem;
import com.ibm.bi.predict.types.DataItem;
import com.ibm.bi.predict.types.RoleType;
import com.ibm.bi.predict.types.Slot;
import com.ibm.bi.predict.types.SlotType;
import com.ibm.bi.predict.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONObject;

class VisRecommenderSlot {
    static final String NAME_KEY = "name";
    static final String TYPE_KEY = "type";
    static final String ROLE_KEY = "role";
    static final String ITEMS_KEY = "items";
    final String name;
    final String type;
    final RoleType role;
    final List<VisRecommenderItem> items;

    VisRecommenderSlot(String name, String type, RoleType role, List<VisRecommenderItem> items) {
        this.name = name;
        this.type = type;
        this.role = role;
        this.items = items;
    }

    void createDataItemsAndSlot(int slotIndex, DataColumn.ColumnMeta target, List<DataColumn.ColumnMeta> drivers, List<DataItem> dataItems, List<Slot> slots) {
        SlotType realType = this.getType(target, drivers);
        ArrayList<DataItem> slotItems = new ArrayList<DataItem>();
        for (int itemIndex = 0; itemIndex < this.items.size(); ++itemIndex) {
            slotItems.add(this.items.get(itemIndex).createDataItem(slotIndex, itemIndex, target, drivers));
        }
        List itemIds = slotItems.stream().map(item -> item.getId()).collect(Collectors.toList());
        dataItems.addAll(slotItems);
        slots.add(new Slot(this.name, itemIds, realType, this.role));
    }

    SlotType getType(DataColumn.ColumnMeta target, List<DataColumn.ColumnMeta> drivers) {
        DataColumn.ColumnMeta meta = VisRecommenderItem.getMeta(this.type, target, drivers);
        if (meta != null) {
            return meta.getType() == FieldType.CATEGORICAL ? SlotType.CATEGORICAL : SlotType.CONTINUOUS;
        }
        return SlotType.fromString((String)this.type);
    }

    static VisRecommenderSlot fromJSON(JSONObject obj) {
        try {
            String name = JsonUtils.getRequiredString((JSONObject)obj, (String)NAME_KEY);
            String type = JsonUtils.getRequiredString((JSONObject)obj, (String)TYPE_KEY);
            RoleType role = RoleType.fromString((String)JsonUtils.getRequiredString((JSONObject)obj, (String)ROLE_KEY));
            ArrayList<VisRecommenderItem> items = new ArrayList<VisRecommenderItem>();
            JSONArray a = JsonUtils.getRequiredJSONArray((JSONObject)obj, (String)ITEMS_KEY);
            int size = a.size();
            for (int i = 0; i < size; ++i) {
                items.add(VisRecommenderItem.fromJSON(JsonUtils.getRequiredJSONObject((JSONArray)a, (int)i, (String)ITEMS_KEY)));
            }
            return new VisRecommenderSlot(name, type, role, items);
        }
        catch (Exception e) {
            throw new BadParametersException("Parsing rule assignment: " + e.getMessage(), (Throwable)e);
        }
    }
}

