/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.services;

import com.ibm.bi.json.JsonFactory;
import com.ibm.bi.soap.schema.DeserializationContext;
import com.ibm.bi.soap.schema.Method;
import com.ibm.bi.soap.schema.SoapFaultHandler;
import com.ibm.bi.soap.schema.TypeLibrary;
import com.ibm.bi.soap.services.BiBus;
import com.ibm.bi.soap.services.ServiceLoader;
import com.ibm.bi.soap.services.SoapException;
import com.ibm.bi.soap.services.SoapService;
import com.ibm.bi.soap.xml.XMLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class DeliveryService
extends SoapService
implements SoapFaultHandler {
    private static Method ADD_NOTIFICATION;
    private static Method DELETE_NOTIFICATION;
    private static Method QUERY_NOTIFICATION;
    private static Method RUN;

    public DeliveryService(BiBus bus) {
        super(bus);
    }

    static void init(TypeLibrary typeLib) throws XMLStreamException, IOException {
        ServiceLoader serviceLoader = new ServiceLoader();
        try (InputStream is = DeliveryService.class.getResourceAsStream("deliveryService.xml");){
            HashMap<String, Method> methods = serviceLoader.load(typeLib, is);
            ADD_NOTIFICATION = methods.get("addNotification");
            DELETE_NOTIFICATION = methods.get("deleteNotification");
            QUERY_NOTIFICATION = methods.get("queryNotification");
            RUN = methods.get("run");
        }
    }

    public void addNotification(String searchPath) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map obj = json.createObject();
        obj.put("objectPath", searchPath);
        this.invoke(ADD_NOTIFICATION, obj);
    }

    public void deleteNotification(String searchPath) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map obj = json.createObject();
        obj.put("objectPath", searchPath);
        this.invoke(DELETE_NOTIFICATION, obj);
    }

    public Map queryNotification(String searchPath) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map obj = json.createObject();
        obj.put("objectPath", searchPath);
        return (Map)this.invoke(QUERY_NOTIFICATION, obj);
    }

    @Override
    public void parseFault(DeserializationContext dc) throws SoapException, XMLStreamException {
        String tagContent = null;
        StringBuilder textBuilder = new StringBuilder();
        Map detail = dc.json.createObject();
        List exceptionMessages = dc.json.createArray();
        String faultCode = null;
        while (dc.reader.hasNext()) {
            int event = dc.reader.next();
            switch (event) {
                case 4: {
                    tagContent = dc.reader.getText();
                    textBuilder.append(tagContent);
                    break;
                }
                case 2: {
                    if ("faultcode".equals(dc.reader.getLocalName())) {
                        detail.put(dc.json.createString("faultcode"), XMLUtils.collapseWhiteSpace(textBuilder.toString()));
                    } else if ("faultstring".equals(dc.reader.getLocalName())) {
                        detail.put(dc.json.createString("faultstring"), XMLUtils.collapseWhiteSpace(textBuilder.toString()));
                    } else if ("severity".equals(dc.reader.getLocalName())) {
                        detail.put(dc.json.createString("severity"), XMLUtils.collapseWhiteSpace(textBuilder.toString()));
                    } else if ("errorCode".equals(dc.reader.getLocalName())) {
                        faultCode = XMLUtils.collapseWhiteSpace(textBuilder.toString());
                        detail.put(dc.json.createString("errorCode"), faultCode);
                    } else if ("messageString".equals(dc.reader.getLocalName())) {
                        if (exceptionMessages != null) {
                            exceptionMessages.add(XMLUtils.collapseWhiteSpace(textBuilder.toString()));
                        }
                    } else if ("exception".equals(dc.reader.getLocalName())) {
                        detail.put(dc.json.createString("messages"), exceptionMessages);
                    }
                    textBuilder.setLength(0);
                    break;
                }
            }
        }
        if (faultCode != null && !"".equals(faultCode)) {
            throw new SoapException(400, faultCode, detail);
        }
    }

    public Map run(String objectPath, List parameterValues, List options) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map runRequest = json.createObject();
        runRequest.put(json.createString("objectPath"), objectPath);
        runRequest.put(json.createString("parameterValues"), parameterValues);
        runRequest.put(json.createString("options"), options);
        return (Map)this.invoke(RUN, runRequest);
    }

    @Override
    protected SoapFaultHandler getSoapFaultHandler() {
        return this;
    }
}

