/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.IPFAuditFunction;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.KeyStoreManager;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Date;
import javax.net.ssl.KeyManager;
import javax.net.ssl.X509KeyManager;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class CAMX509KeyManager14
implements X509KeyManager {
    static String tempAlias = "temp";
    private static final String TEMP_CERT_NAME = "CN=C4MCRYP70,O=Cognos,C=CA";
    private RSAPrivateKey tmpPrivKey = null;
    X509KeyManager sunX509KeyManager;
    String encryptionAlias;
    private X509Certificate[] newCertChain = null;
    private boolean bCertCacheReloaded = false;
    private PrivateKey newPrivateKey = null;

    public CAMX509KeyManager14(KeyManager kms, String encryptionAlias) {
        this.sunX509KeyManager = (X509KeyManager)kms;
        this.encryptionAlias = encryptionAlias;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] aprincipal, Socket socket) {
        try {
            this.newPrivateKey = KeyStoreReader.getEncryptionPrivateKey();
        }
        catch (CAMCryptoException e) {
            return tempAlias;
        }
        String preferredKeyType = keyType[0];
        String[] aliases = this.sunX509KeyManager.getClientAliases(preferredKeyType, aprincipal);
        if (aliases == null || aliases.length == 0) {
            return null;
        }
        for (int a = 0; a < aliases.length; ++a) {
            if (!aliases[a].equals(this.encryptionAlias)) continue;
            return aliases[a];
        }
        return null;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] aprincipal, Socket socket) {
        String[] aliases = this.sunX509KeyManager.getServerAliases(keyType, aprincipal);
        if (aliases == null || aliases.length == 0) {
            return null;
        }
        for (int a = 0; a < aliases.length; ++a) {
            if (!aliases[a].equals(this.encryptionAlias)) continue;
            return aliases[a];
        }
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String s) {
        if (s.compareTo(tempAlias) == 0) {
            X509Certificate[] chain = new X509Certificate[]{this.createTemporarySelfSignedCertificate()};
            return chain;
        }
        if (this.bCertCacheReloaded) {
            return this.newCertChain;
        }
        boolean isValid = true;
        X509Certificate[] cachedChain = this.sunX509KeyManager.getCertificateChain(s);
        for (int i = 0; i < cachedChain.length; ++i) {
            try {
                cachedChain[i].checkValidity();
                continue;
            }
            catch (CertificateExpiredException cee) {
                isValid = false;
                IPFAuditFunction.trace("Certificate Expired for " + cachedChain[i].getSubjectDN());
                break;
            }
            catch (CertificateNotYetValidException cnyv) {
                isValid = false;
                IPFAuditFunction.trace("Certificate Net Yet Valid for " + cachedChain[i].getSubjectDN());
                break;
            }
        }
        if (isValid) {
            return cachedChain;
        }
        KeyStoreManager ksMgr = KeyStoreManager.getInstance();
        ksMgr.resetencKeyStore();
        X509Certificate[] newCertChain = null;
        try {
            newCertChain = KeyStoreReader.getEncryptionX509CertificateChain();
        }
        catch (Exception e) {
            IPFAuditFunction.trace("Error reloading certificate chain");
        }
        isValid = true;
        for (int i = 0; i < newCertChain.length; ++i) {
            try {
                newCertChain[i].checkValidity();
                continue;
            }
            catch (CertificateExpiredException cee) {
                isValid = false;
                IPFAuditFunction.trace("Certificate Expired for " + newCertChain[i].getSubjectDN());
                break;
            }
            catch (CertificateNotYetValidException cnyv) {
                isValid = false;
                IPFAuditFunction.trace("Certificate Net Yet Valid for " + newCertChain[i].getSubjectDN());
                break;
            }
        }
        this.bCertCacheReloaded = true;
        if (isValid) {
            return newCertChain;
        }
        IPFAuditFunction.trace("No valid chain. Returning cached chain");
        return cachedChain;
    }

    @Override
    public String[] getClientAliases(String s, Principal[] aprincipal) {
        return this.sunX509KeyManager.getClientAliases(s, aprincipal);
    }

    @Override
    public PrivateKey getPrivateKey(String s) {
        if (s.compareTo(tempAlias) == 0) {
            return this.tmpPrivKey;
        }
        if (this.newPrivateKey != null) {
            return this.newPrivateKey;
        }
        if (this.bCertCacheReloaded) {
            try {
                KeyStoreManager ksMgr = KeyStoreManager.getInstance();
                ksMgr.resetencKeyStore();
                this.newPrivateKey = KeyStoreReader.getEncryptionPrivateKey();
            }
            catch (CAMCryptoException cAMCryptoException) {
                // empty catch block
            }
            return this.newPrivateKey;
        }
        return this.sunX509KeyManager.getPrivateKey(s);
    }

    @Override
    public String[] getServerAliases(String s, Principal[] aprincipal) {
        return this.sunX509KeyManager.getServerAliases(s, aprincipal);
    }

    private X509Certificate createTemporarySelfSignedCertificate() {
        String hostIP;
        KeyPairGenerator keyGen = null;
        try {
            String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
            keyGen = KeyPairGenerator.getInstance("RSA", jceProvider);
        }
        catch (Exception e) {
            return null;
        }
        keyGen.initialize(512);
        KeyPair keypair = keyGen.generateKeyPair();
        RSAPublicKey pk = (RSAPublicKey)keypair.getPublic();
        this.tmpPrivKey = (RSAPrivateKey)keypair.getPrivate();
        Configuration config = Configuration.getInstance();
        X509V3CertificateGenerator X509gen = new X509V3CertificateGenerator();
        try {
            String shaAlg = config.getDigestAlgorithm();
            String signatureAlg = shaAlg + "withRSA";
            X509gen.setSignatureAlgorithm(signatureAlg);
        }
        catch (CAMCryptoException e1) {
            return null;
        }
        Date currentDate = new Date();
        long currentTime = currentDate.getTime();
        Date expiryDate = new Date(currentTime + 259200000L);
        Date startDate = new Date(currentTime - 172800000L);
        X509gen.setNotBefore(startDate);
        X509gen.setNotAfter(expiryDate);
        String dn = new String(TEMP_CERT_NAME);
        X509Name x509dn = new X509Name(dn);
        X509gen.setSubjectDN(x509dn);
        X509gen.setIssuerDN(x509dn);
        X509gen.setPublicKey((PublicKey)pk);
        SecureRandom random = null;
        try {
            random = JVMEnvironment.getInstance().getSecureRandom();
        }
        catch (Exception e) {
            return null;
        }
        byte[] seed = random.generateSeed(20);
        random.setSeed(seed);
        BigInteger bi = new BigInteger(20, random);
        X509gen.setSerialNumber(bi);
        try {
            hostIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return null;
        }
        ArrayList<GeneralName> altNames = new ArrayList<GeneralName>();
        altNames.add(new GeneralName(7, hostIP));
        if (altNames.size() > 0) {
            GeneralNames gns = new GeneralNames(altNames.toArray(new GeneralName[altNames.size()]));
            boolean critical = false;
            X509gen.addExtension(X509Extensions.SubjectAlternativeName, critical, (ASN1Encodable)gns);
        }
        try {
            Configuration cnfg = Configuration.getInstance();
            String caPwd = cnfg.getCAPassword();
            byte[] serialbytes = bi.toByteArray();
            byte[] hmacBytes = CryptoWrapper.calculateHMAC(serialbytes, caPwd);
            SubjectKeyIdentifier ski = new SubjectKeyIdentifier(hmacBytes);
            X509gen.addExtension(X509Extensions.SubjectKeyIdentifier, false, (ASN1Encodable)ski);
        }
        catch (CAMCryptoException e) {
            return null;
        }
        X509Certificate x509cert = null;
        try {
            x509cert = X509gen.generateX509Certificate(keypair.getPrivate());
        }
        catch (InvalidKeyException ike) {
            return null;
        }
        catch (GeneralSecurityException gse) {
            return null;
        }
        return x509cert;
    }
}

