/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.jni.JNISystemProperties;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.IJVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.IPFTraceFunction;
import com.cognos.accman.jcam.crypto.misc.JSSEDynamicSocketFactoryInitializer;
import com.cognos.accman.res.MessageSet;
import com.cognos.cclcfgapi.CCLConfigurationUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Locale;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class JVMEnvironment
implements IJVMEnvironment {
    private static IJVMEnvironment s_instance = null;
    private String jceProviderName;
    private String jceProviderClass;
    private String jsseProviderName;
    private String jsseProviderClass;
    private String pbeProviderName;
    private String httpsProtocolHandler;
    private SecureRandom secureRandom;
    private String trustAndKeyManagerAlgorithm;
    private SSLContext sslContext = null;
    private SSLSocketFactory sslSocketFactory = null;
    private SSLServerSocketFactory sslServerSocketFactory = null;
    private SSLSocketFactory pkcs12SSLSocketFactory = null;
    private SSLServerSocketFactory pkcs12SSLServerSocketFactory = null;
    private boolean completedSetup = false;
    private boolean isFIPSEnabled = false;
    private boolean onlyUseSHA_2 = false;
    private boolean rejectNonFipsJavaScriptHashes = false;
    private static boolean isIBMJava = true;
    private static boolean isDisableNIST131a = false;
    private static final String IBM_JCE_CLASS = "com.ibm.crypto.provider.IBMJCE";
    private static final String SUN_JCE_CLASS = "com.sun.crypto.provider.SunJCE";
    private static final String IBM_JSSE2_CLASS = "com.ibm.jsse2.IBMJSSEProvider2";
    private static final String IBM_JSSE_CLASS = "com.ibm.jsse.IBMJSSEProvider";
    private static final String SUN_JSSE_CLASS = "com.sun.net.ssl.internal.ssl.Provider";
    private static final String IBM_JCE_PROV = "IBMJCE";
    private static final String SUN_JCE_PROV = "SunJCE";
    private static final String IBM_JSSE2_PROV = "IBMJSSE2";
    private static final String IBM_JSSE_PROV = "IBMJSSE";
    private static final String SUN_JSSE_PROV = "SunJSSE";
    private static final String IBM_X509_TRUST_AND_KEY_MANAGER = "IbmX509";
    private static final String SUN_X509_TRUST_AND_KEY_MANAGER = "SunX509";
    private static final String FIPS_MODE_FILE = CCLConfigurationUtils.resolveEffectivePath((String)"../configuration/FIPS.mode");
    private static final String IBM_JCE_FIPS_PROV = "IBMJCEFIPS";
    private static final String IBM_JCE_FIPS_CLASS = "com.ibm.crypto.fips.provider.IBMJCEFIPS";
    private static final String PKCS12KEYSTORE_TYPE_FIPS = "PKCS12-3DES-3DES";
    private static final String PKCS12KEYSTORE_TYPE = "PKCS12-DEF";
    private static final String FALSE = "false";

    public static IJVMEnvironment getInstance() throws CAMCryptoException {
        if (s_instance == null) {
            s_instance = new JVMEnvironment(null, null);
        }
        if (s_instance instanceof JVMEnvironment) {
            ((JVMEnvironment)s_instance).completeSetup();
        }
        return s_instance;
    }

    public static void setInstance(IJVMEnvironment inst) throws CAMCryptoException {
        s_instance = inst;
    }

    public static void deleteInstance() {
        if (s_instance != null) {
            s_instance = null;
        }
    }

    public JVMEnvironment(String fipsModeConfig, String forcedProvidertype) throws CAMCryptoException {
        String fipsFile = null;
        fipsFile = fipsModeConfig == null ? FIPS_MODE_FILE : fipsModeConfig;
        this.parseFIPSModeSetting(fipsFile);
        if (JVMEnvironment.canProviderClassBeFound(IBM_JCE_CLASS)) {
            if (this.isFIPSEnabled) {
                this.jceProviderName = IBM_JCE_FIPS_PROV;
                this.jceProviderClass = IBM_JCE_FIPS_CLASS;
                this.pbeProviderName = IBM_JCE_PROV;
            } else {
                this.jceProviderName = IBM_JCE_PROV;
                this.jceProviderClass = IBM_JCE_CLASS;
                this.pbeProviderName = IBM_JCE_PROV;
            }
            isIBMJava = true;
        } else if (JVMEnvironment.canProviderClassBeFound(SUN_JCE_CLASS)) {
            this.jceProviderName = SUN_JCE_PROV;
            this.jceProviderClass = SUN_JCE_CLASS;
            this.pbeProviderName = SUN_JCE_PROV;
            isIBMJava = false;
        } else {
            Throwable t1 = null;
            try {
                Class.forName(IBM_JCE_CLASS);
            }
            catch (Throwable thr) {
                t1 = thr;
            }
            if (t1 != null && !(t1 instanceof ClassNotFoundException)) {
                throw new CAMCryptoException(t1, MessageSet.getMessage("CAM_CRP_jvm_env_could_not_find_jce", new String[]{IBM_JCE_CLASS}));
            }
            Throwable t2 = null;
            try {
                Class.forName(SUN_JCE_CLASS);
            }
            catch (Throwable thr) {
                t2 = thr;
            }
            if (t2 != null && !(t2 instanceof ClassNotFoundException)) {
                throw new CAMCryptoException(t2, MessageSet.getMessage("CAM_CRP_jvm_env_could_not_find_jce", new String[]{SUN_JCE_CLASS}));
            }
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_jvm_env_could_not_find_jce", new String[]{"com.ibm.crypto.provider.IBMJCE/com.sun.crypto.provider.SunJCE"}));
        }
        this.httpsProtocolHandler = "com.sun.net.ssl.internal.www.protocol";
        if (JVMEnvironment.canProviderClassBeFound(IBM_JSSE2_CLASS)) {
            this.httpsProtocolHandler = "com.ibm.net.ssl.www2.protocol";
        } else if (JVMEnvironment.canProviderClassBeFound(IBM_JSSE_CLASS)) {
            this.httpsProtocolHandler = "com.ibm.net.ssl.www.protocol";
        }
        String jvmVersion = System.getProperty("java.version");
        IPFTraceFunction.trace("JVM is version '" + jvmVersion + "'");
        IPFTraceFunction.trace("JCE provider is '" + this.jceProviderName + "'");
        IPFTraceFunction.trace("JCE provider class is '" + this.jceProviderClass + "'");
        IPFTraceFunction.trace("PBE provider is '" + this.pbeProviderName + "'");
        IPFTraceFunction.trace("HTTPS URL protocol handler is '" + this.httpsProtocolHandler + "'");
    }

    @Override
    public boolean isFIPSSupportedOS() throws CAMCryptoException {
        return this.isFIPSSupportedOS(true);
    }

    @Override
    public boolean isFIPSSupportedOS(boolean isConfigTool) throws CAMCryptoException {
        boolean isOSVioliation;
        if (this.isFIPSEnabled && (isOSVioliation = JNISystemProperties.CheckFIPSOsViolation())) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CAP_not_supported_fips_OS", Locale.getDefault().toString()));
        }
        Configuration.getInstanceWithDefaultConfig(isConfigTool);
        return true;
    }

    private void parseFIPSModeSetting(String fipsFile) throws CAMCryptoException {
        try {
            BufferedReader r = new BufferedReader(new FileReader(fipsFile));
            this.isFIPSEnabled = true;
            this.onlyUseSHA_2 = true;
            this.rejectNonFipsJavaScriptHashes = true;
            String line = null;
            while ((line = r.readLine()) != null) {
                int index = line.indexOf(61);
                if (index == -1) continue;
                String name = line.substring(0, index);
                String value = line.substring(index + 1);
                if ((name = name.trim()).equalsIgnoreCase("OnlyUseSHA-2") && (value = value.trim()).equalsIgnoreCase(FALSE)) {
                    this.onlyUseSHA_2 = false;
                }
                if (!name.equalsIgnoreCase("RejectNonFipsJavaScriptHashes") || !(value = value.trim()).equalsIgnoreCase(FALSE)) continue;
                this.rejectNonFipsJavaScriptHashes = false;
            }
        }
        catch (FileNotFoundException e) {
            this.isFIPSEnabled = false;
            this.onlyUseSHA_2 = false;
            this.rejectNonFipsJavaScriptHashes = false;
        }
        catch (IOException e) {
            System.out.println("Problem reading FIPS file:" + fipsFile);
            e.printStackTrace();
        }
    }

    @Override
    public boolean OnlyUseSHA_2() {
        return this.onlyUseSHA_2;
    }

    @Override
    public boolean RejectNonFipsJavaScriptHashes() {
        return this.rejectNonFipsJavaScriptHashes;
    }

    @Override
    public boolean isDisableNIST131a() {
        return isDisableNIST131a;
    }

    @Override
    public void setEnableNIST_SP_800_131A() {
        isDisableNIST131a = false;
        this.onlyUseSHA_2 = true;
    }

    @Override
    public void setDisableNIST131a(boolean bDisable) {
        isDisableNIST131a = bDisable;
        this.onlyUseSHA_2 = !bDisable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void completeSetup() throws CAMCryptoException {
        if (this.completedSetup) {
            return;
        }
        if (JVMEnvironment.canProviderClassBeFound(IBM_JSSE2_CLASS)) {
            this.jsseProviderName = IBM_JSSE2_PROV;
            this.jsseProviderClass = IBM_JSSE2_CLASS;
            this.trustAndKeyManagerAlgorithm = IBM_X509_TRUST_AND_KEY_MANAGER;
            if (this.isFIPSEnabled) {
                System.setProperty("com.ibm.jsse2.usefipsprovider", "true");
            }
        } else {
            if (this.isFIPSEnabled) {
                IPFTraceFunction.trace("JVMEnvironment::ComleteSetup - no provider found AND FIPS enabled.");
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_jvm_env_could_not_find_jsse", new String[]{"com.ibm.jsse2.IBMJSSEProvider2/com.ibm.jsse.IBMJSSEProvider/com.sun.net.ssl.internal.ssl.Provider"}));
            }
            if (JVMEnvironment.canProviderClassBeFound(IBM_JSSE_CLASS)) {
                this.jsseProviderName = IBM_JSSE_PROV;
                this.jsseProviderClass = IBM_JSSE_CLASS;
                this.trustAndKeyManagerAlgorithm = IBM_X509_TRUST_AND_KEY_MANAGER;
            } else if (JVMEnvironment.canProviderClassBeFound(SUN_JSSE_CLASS)) {
                this.jsseProviderName = SUN_JSSE_PROV;
                this.jsseProviderClass = SUN_JSSE_CLASS;
                this.trustAndKeyManagerAlgorithm = SUN_X509_TRUST_AND_KEY_MANAGER;
            } else {
                Throwable t1 = null;
                try {
                    Class.forName(IBM_JSSE2_CLASS);
                }
                catch (Throwable thr) {
                    t1 = thr;
                }
                if (t1 != null && !(t1 instanceof ClassNotFoundException)) {
                    throw new CAMCryptoException(t1, MessageSet.getMessage("CAM_CRP_jvm_env_could_not_find_jsse", new String[]{IBM_JSSE2_CLASS}));
                }
                Throwable t2 = null;
                try {
                    Class.forName(IBM_JSSE_CLASS);
                }
                catch (Throwable thr) {
                    t2 = thr;
                }
                if (t2 != null && !(t2 instanceof ClassNotFoundException)) {
                    throw new CAMCryptoException(t2, MessageSet.getMessage("CAM_CRP_jvm_env_could_not_find_jsse", new String[]{IBM_JSSE_CLASS}));
                }
                Throwable t3 = null;
                try {
                    Class.forName(SUN_JSSE_CLASS);
                }
                catch (Throwable thr) {
                    t3 = thr;
                }
                if (t3 != null && !(t3 instanceof ClassNotFoundException)) {
                    throw new CAMCryptoException(t3, MessageSet.getMessage("CAM_CRP_jvm_env_could_not_find_jsse", new String[]{SUN_JSSE_CLASS}));
                }
                IPFTraceFunction.trace("JVMEnvironment::ComleteSetup - no provider found AND FIPS disabled.");
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_jvm_env_could_not_find_jsse", new String[]{"com.ibm.jsse2.IBMJSSEProvider2/com.ibm.jsse.IBMJSSEProvider/com.sun.net.ssl.internal.ssl.Provider"}));
            }
        }
        this.setupSecureRandom();
        boolean skipThis = false;
        try {
            Class.forName("com.cognos.indications.LogIndication");
        }
        catch (Throwable t) {
            skipThis = true;
        }
        if (!skipThis) {
            IPFTraceFunction.trace("JSSE provider is '" + this.jsseProviderName + "'");
            IPFTraceFunction.trace("JSSE provider class is '" + this.jsseProviderClass + "'");
            IPFTraceFunction.trace("JSSE Trust and Key manager algorithm name is '" + this.trustAndKeyManagerAlgorithm + "'");
            IPFTraceFunction.trace("SecureRandom provider is '" + this.secureRandom.getProvider().getName() + "'");
        }
        this.completedSetup = true;
    }

    private void setupSecureRandom() throws CAMCryptoException {
        try {
            this.secureRandom = SecureRandom.getInstance("SHA2DRBG", this.jceProviderName);
        }
        catch (NoSuchAlgorithmException nsae) {
            if (this.isFIPSEnabled) {
                try {
                    this.secureRandom = SecureRandom.getInstance("SHA2DRBG", this.jceProviderName);
                }
                catch (Exception e) {
                    throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_jvm_env_could_not_find_securerandom", new String[]{"IBMSecureRandom/" + this.jceProviderName}));
                }
            }
            if (this.jceProviderName.compareToIgnoreCase(SUN_JCE_PROV) == 0) {
                try {
                    this.secureRandom = SecureRandom.getInstance("SHA1PRNG");
                }
                catch (Exception e) {
                    throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_jvm_env_could_not_find_securerandom", new String[]{"SHA1PRNG/" + this.jceProviderName}));
                }
            }
            throw new CAMCryptoException(nsae, MessageSet.getMessage("CAM_CRP_jvm_env_could_not_find_SHA2DRBG", new String[]{"SHA2DRBG/" + this.jceProviderName}));
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_jvm_env_could_not_find_securerandom", new String[]{this.jceProviderName}));
        }
    }

    private void assertSetupCompleted() throws CAMCryptoException {
        this.completeSetup();
        if (!this.completedSetup) {
            throw new CAMCryptoException("CAM-CRP-XXX Internal error - JVM environment information has been requested but its set up has not yet been fully completed.");
        }
    }

    @Override
    public String getJSSEProviderName() {
        return this.jsseProviderName;
    }

    @Override
    public String getJCEProvider() {
        return this.jceProviderName;
    }

    @Override
    public String getPBEProvider() {
        return this.pbeProviderName;
    }

    @Override
    public String getHttpsProtocolHandler() {
        return this.httpsProtocolHandler;
    }

    @Override
    public SecureRandom getSecureRandom() throws CAMCryptoException {
        this.assertSetupCompleted();
        return this.secureRandom;
    }

    @Override
    public SSLContext getSSLContext() throws CAMCryptoException {
        if (this.sslContext != null) {
            return this.sslContext;
        }
        this.assertSetupCompleted();
        this.sslContext = JSSEDynamicSocketFactoryInitializer.createSSLContext(this.jsseProviderName, this.trustAndKeyManagerAlgorithm);
        return this.sslContext;
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory(String cryptoProvidertype) throws CAMCryptoException {
        if (cryptoProvidertype == null) {
            return this.getSSLSocketFactory();
        }
        return new JVMEnvironment(null, cryptoProvidertype).getSSLSocketFactory();
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory() throws CAMCryptoException {
        if (this.sslSocketFactory != null) {
            return this.sslSocketFactory;
        }
        this.assertSetupCompleted();
        this.sslSocketFactory = JSSEDynamicSocketFactoryInitializer.getJRE14SocketFactory(this.jsseProviderName, this.trustAndKeyManagerAlgorithm);
        return this.sslSocketFactory;
    }

    @Override
    public SSLServerSocketFactory getSSLServerSocketFactory() throws CAMCryptoException {
        if (this.sslServerSocketFactory != null) {
            return this.sslServerSocketFactory;
        }
        this.assertSetupCompleted();
        this.sslServerSocketFactory = JSSEDynamicSocketFactoryInitializer.getJRE14ServerSocketFactory(this.jsseProviderName, this.trustAndKeyManagerAlgorithm);
        return this.sslServerSocketFactory;
    }

    @Override
    public SSLSocketFactory getPKCS12SSLSocketFactory(String p12File, String p12FilePassword) throws CAMCryptoException, CertificateExpiredException, CertificateNotYetValidException {
        if (this.pkcs12SSLSocketFactory != null) {
            return this.pkcs12SSLSocketFactory;
        }
        this.assertSetupCompleted();
        this.pkcs12SSLSocketFactory = JSSEDynamicSocketFactoryInitializer.getPKCS12SocketFactory(p12File, p12FilePassword, this.jsseProviderName, this.trustAndKeyManagerAlgorithm);
        return this.pkcs12SSLSocketFactory;
    }

    @Override
    public SSLServerSocketFactory getPKCS12SSLServerSocketFactory(String pkcs12File, String pkcs12FilePassword) throws CAMCryptoException, CertificateExpiredException, CertificateNotYetValidException {
        if (this.pkcs12SSLServerSocketFactory != null) {
            return this.pkcs12SSLServerSocketFactory;
        }
        this.assertSetupCompleted();
        this.pkcs12SSLServerSocketFactory = JSSEDynamicSocketFactoryInitializer.getPKCS12ServerSocketFactory(pkcs12File, pkcs12FilePassword, this.jsseProviderName, this.trustAndKeyManagerAlgorithm);
        return this.pkcs12SSLServerSocketFactory;
    }

    @Override
    public String getJRECACertsLocation() throws CAMCryptoException {
        String cacertsLocation = null;
        cacertsLocation = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
        return cacertsLocation;
    }

    @Override
    public void addJCESecurityProvider() throws CAMCryptoException {
        try {
            Provider p;
            if (!JVMEnvironment.isProviderInstalled("SUN") && JVMEnvironment.canProviderClassBeFound("sun.security.provider.Sun")) {
                Class<?> sunClass = Class.forName("sun.security.provider.Sun");
                p = (Provider)sunClass.newInstance();
                Security.addProvider(p);
            }
            if (!JVMEnvironment.isProviderInstalled(this.jceProviderName)) {
                Class<?> jceClass = Class.forName(this.jceProviderClass);
                p = (Provider)jceClass.newInstance();
                Security.addProvider(p);
            }
        }
        catch (Exception e) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_jvm_env_could_not_add_jce"));
        }
    }

    @Override
    public void addJSSESecurityProvider() throws CAMCryptoException {
        this.assertSetupCompleted();
        try {
            if (!JVMEnvironment.isProviderInstalled(this.jsseProviderName)) {
                Class<?> jsseClass = Class.forName(this.jsseProviderClass);
                Provider p = (Provider)jsseClass.newInstance();
                Security.addProvider(p);
            }
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_jvm_env_could_not_add_jsse"));
        }
    }

    public static boolean canProviderClassBeFound(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean isProviderInstalled(String providerName) {
        return Security.getProvider(providerName) != null;
    }

    @Override
    public boolean isIBMJava() {
        return isIBMJava;
    }

    public static float getJvmVersion() {
        String sVersion = System.getProperty("java.version");
        int secondDecimalPos = sVersion.indexOf(46, sVersion.indexOf(46) + 1);
        if (secondDecimalPos == -1) {
            secondDecimalPos = sVersion.indexOf(46) + 2;
        }
        float version = Float.parseFloat(sVersion.substring(0, secondDecimalPos));
        return version;
    }

    @Override
    public boolean isFIPSEnabled() {
        return this.isFIPSEnabled;
    }

    @Override
    public String getPKCS12KeystoreType() {
        if (this.isFIPSEnabled) {
            return PKCS12KEYSTORE_TYPE_FIPS;
        }
        return PKCS12KEYSTORE_TYPE;
    }
}

