/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.bibus;

import com.cognos.ccl4j.bibus.CAMCookie;
import com.cognos.ccl4j.util.CCLWeb64;
import java.io.UnsupportedEncodingException;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class CAMCookieImpl
implements CAMCookie {
    public static final String DELIMITER = ";";
    protected static final String FLAG_SET = "1";
    protected static final String FLAG_NOT_SET = "0";
    private static final int PID_HEADER_SIZE = 4;
    private static final int PID_HEADER_NAMESPACES_CONFIGURED_FLAG_START = 0;
    private static final int PID_HEADER_NAMESPACES_CONFIGURED_FLAG_END = 1;
    private static final int PID_HEADER_ANONYMOUS_CONFIGURED_FLAG_START = 1;
    private static final int PID_HEADER_ANONYMOUS_CONFIGURED_FLAG_END = 2;
    private static final int PID_HEADER_NAMED_USER_FLAG_START = 2;
    private static final int PID_HEADER_NAMED_USER_FLAG_END = 3;
    private static final int COOKIE_VERSION_POSITION = 0;
    private static final int COOKIE_PASSPORT_ID_POSITION = 1;
    private static final int COOKIE_LOGGING_ENABLED_POSITION = 2;
    private static final int COOKIE_PASSPORT_GENERATION_POSITION = 3;
    private static final int COOKIE_CAN_CALL_LOGON_POSITION = 4;
    private static final String XSI_NS_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XSI_NS_PREFIX = "xsi";
    private static final QName XSI_TYPE = QName.get((String)"type", (String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private static final String BUS_PASSPORT = "bus:CAMPassport";
    private static final String BUS_SETTINGS = "bus:CAMSettings";
    private static final String XSD_STRING = "xsd:string";
    private static final String XSD_BOOLEAN = "xsd:boolean";
    private static final String XSD_INT = "xsd:int";
    private static final QName CAM = QName.get((String)"bus:CAM", (String)"http://developer.cognos.com/schemas/bibus/3/");
    private static final String XSD = "xsd";
    private static final String XSI = "xsi";
    private String passportID;
    private int version;
    private String action;
    private boolean loggingEnabled;
    private int generation;
    private boolean canUserLogon;

    protected CAMCookieImpl() {
    }

    private CAMCookieImpl(String theCookieValue) {
        this.version = 0;
        this.action = null;
        this.loggingEnabled = true;
        this.generation = 0;
        this.canUserLogon = true;
        this.passportID = null;
        if (theCookieValue == null || theCookieValue.length() <= 4) {
            return;
        }
        int startPos = 0;
        if (theCookieValue.charAt(3) == ':') {
            this.passportID = theCookieValue;
            this.generation = 1;
        } else {
            String decodedCookieValue;
            String substring = null;
            int elementNumber = 0;
            try {
                byte[] decodedCookieBytes = CCLWeb64.decode(theCookieValue);
                decodedCookieValue = new String(decodedCookieBytes, "UTF-8");
            }
            catch (CCLWeb64.InvalidWeb64Exception e) {
                decodedCookieValue = "";
            }
            catch (UnsupportedEncodingException e) {
                decodedCookieValue = "";
            }
            int tokenLocation = decodedCookieValue.indexOf(DELIMITER, startPos);
            while (tokenLocation != -1 && startPos < decodedCookieValue.length()) {
                tokenLocation = decodedCookieValue.indexOf(DELIMITER, startPos);
                substring = decodedCookieValue.substring(startPos, tokenLocation);
                startPos = tokenLocation + DELIMITER.length();
                switch (elementNumber) {
                    case 0: {
                        this.version = Integer.valueOf(substring);
                        break;
                    }
                    case 1: {
                        this.passportID = substring;
                        break;
                    }
                    case 2: {
                        this.loggingEnabled = substring.equals(FLAG_SET);
                        break;
                    }
                    case 3: {
                        this.generation = Integer.valueOf(substring);
                        break;
                    }
                    case 4: {
                        this.canUserLogon = substring.equals(FLAG_SET);
                        break;
                    }
                }
                ++elementNumber;
            }
            this.action = null;
        }
    }

    public static CAMCookie createCookie(String theCookieValue) {
        return new CAMCookieImpl(theCookieValue);
    }

    @Override
    public boolean areCamNamespacesConfigured() {
        boolean retval = false;
        if (this.getPassportID() != null && this.getPassportID().length() > 4) {
            String flagBit = this.getPassportID().substring(0, 1);
            retval = flagBit.equals(FLAG_SET);
        }
        return retval;
    }

    @Override
    public Element asXML() throws DocumentException {
        Element camElement = DocumentHelper.createElement((QName)CAM);
        camElement.addNamespace("xsi", XSI_NS_URI);
        camElement.addNamespace(XSD, "http://www.w3.org/2001/XMLSchema");
        camElement.addAttribute(XSI_TYPE, CAM.getQualifiedName());
        if (this.action != null) {
            Element actionElement = camElement.addElement("action");
            actionElement.addText(this.action);
        }
        Element camPassportElement = camElement.addElement("CAMPassport");
        camPassportElement.addAttribute(XSI_TYPE, BUS_PASSPORT);
        Element canCallLogonElement = camPassportElement.addElement("canCallLogon");
        canCallLogonElement.addAttribute(XSI_TYPE, XSD_BOOLEAN);
        canCallLogonElement.addText(Boolean.toString(this.canCurrentUserCallLogon()));
        Element generationElement = camPassportElement.addElement("generation");
        generationElement.addAttribute(XSI_TYPE, XSD_INT);
        generationElement.addText(Integer.toString(this.getPassportGeneration()));
        if (this.passportID != null) {
            Element idElement = camPassportElement.addElement("id");
            idElement.addAttribute(XSI_TYPE, XSD_STRING);
            idElement.addText(this.getPassportID());
        }
        Element logEnabledElement = camPassportElement.addElement("logEnabled");
        logEnabledElement.addAttribute(XSI_TYPE, XSD_BOOLEAN);
        logEnabledElement.addText(Boolean.toString(this.isLoggingEnabled()));
        Element isAnonymousElement = camPassportElement.addElement("isAnonymous");
        isAnonymousElement.addAttribute(XSI_TYPE, XSD_BOOLEAN);
        isAnonymousElement.addText(Boolean.toString(this.isCurrentUserAnonymous()));
        Element camSettingsElement = camElement.addElement("settings");
        camSettingsElement.addAttribute(XSI_TYPE, BUS_SETTINGS);
        Element anonymousAllowedElement = camSettingsElement.addElement("anonymousAllowed");
        anonymousAllowedElement.addAttribute(XSI_TYPE, XSD_BOOLEAN);
        anonymousAllowedElement.addText(Boolean.toString(this.isCamConfiguredForAnonymous()));
        Element namespacesConfiguredElement = camSettingsElement.addElement("namespacesConfigured");
        namespacesConfiguredElement.addAttribute(XSI_TYPE, XSD_BOOLEAN);
        namespacesConfiguredElement.addText(Boolean.toString(this.areCamNamespacesConfigured()));
        return camElement;
    }

    @Override
    public String asXMLString() throws DocumentException {
        return this.asXML().asXML();
    }

    @Override
    public boolean canCurrentUserCallLogon() {
        return this.canUserLogon;
    }

    protected String getAction() {
        return this.action;
    }

    @Override
    public int getPassportGeneration() {
        return this.generation;
    }

    @Override
    public String getPassportID() {
        return this.passportID;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean isCamConfiguredForAnonymous() {
        boolean retval = false;
        if (this.getPassportID() != null && this.getPassportID().length() > 4) {
            String flagBit = this.getPassportID().substring(1, 2);
            retval = flagBit.equals(FLAG_SET);
        }
        return retval;
    }

    @Override
    public boolean isCurrentUserAnonymous() {
        boolean retval = false;
        if (this.getPassportID() != null && this.getPassportID().length() > 4) {
            String flagBit = this.getPassportID().substring(2, 3);
            retval = !flagBit.equals(FLAG_SET);
        }
        return retval;
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    @Override
    public void setAction(String actionName) {
        this.action = actionName;
    }

    protected void setCanCurrentUserCallLogon(boolean canLogon) {
        this.canUserLogon = canLogon;
    }

    protected void setLoggingEnabled(boolean flag) {
        this.loggingEnabled = flag;
    }

    protected void setPassportGeneration(int genNumber) {
        this.generation = genNumber;
    }

    protected void setPassportID(String passport) {
        this.passportID = passport;
    }

    protected void setVersion(int versionNo) {
        this.version = versionNo;
    }
}

