/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.util;

import com.cognos.ccl4j.diagnostics.CCLCheck;
import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.ccl4j.html.CCLHTMLEntities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public final class CCLStringUtils {
    static final String MSG_NULL_PARAM = "null parameter";
    static final String MSG_UNABLE_TO_CONVERT = "Unable to convert string to UTF-8 byte array";
    static final String MSG_ZERO_SEARCH_STRING = "Cannot have a zero-length search string";
    static final String MSG_ZERO_REPLACE_STRING = "Cannot have a zero-length replacement string";
    static final int SPLIT_DEFAULT_ARRAY_SIZE = 50;
    static final String MSG_NULL_MAIN_STRING = "<null> main string parameter";
    static final String MSG_NULL_DELIMITER_STRING = "<null> delimiter parameter";
    static final String MSG_ZERO_LENGTH_DELIMITER = "zero-length delimiter parameter";
    static final String MSG_NULL_REPLACEMENT_MAP = "<null> replacement map";
    static final String MSG_MISSING_END_DELIMITER = "missing end-delimiter";
    static final String MSG_VARIABLE_NOT_IN_MAP = "variable is not in map";
    public static final String DEFAULT_START_MARKER = "${";
    public static final String DEFAULT_END_MARKER = "}";
    public static final boolean STRICT_REPLACE = true;
    public static final boolean NOT_STRICT_REPLACE = false;
    public static final boolean SPLIT_TRIM = true;
    public static final boolean SPLIT_NO_TRIM = false;
    public static final boolean SPLIT_INCLUDE_EMPTY = true;
    public static final boolean SPLIT_EXCLUDE_EMPTY = false;
    public static final String JOIN_DEFAULT_SEPARATOR = ", ";
    public static final boolean JOIN_IGNORE_NULLS = true;
    public static final boolean JOIN_DONT_IGNORE_NULLS = false;
    public static final boolean JOIN_DEFAULT_IGNORE_NULLS = false;
    public static final String JOIN_NULL_STRING = "[null]";
    private static final String TRIM_TRAILER = "...";
    private static final int TRIM_TRAILER_LEN = "...".length();

    public static byte[] String2UTF8ByteArray(String sStringToBeConverted) {
        byte[] baRet = null;
        try {
            baRet = sStringToBeConverted.getBytes("UTF-8");
        }
        catch (Exception ex) {
            if (sStringToBeConverted == null) {
                throw new CCLRuntimeException(MSG_NULL_PARAM);
            }
            throw new CCLRuntimeException(ex, MSG_UNABLE_TO_CONVERT);
        }
        return baRet;
    }

    public static String join(List vObjects) {
        return CCLStringUtils.join(vObjects, JOIN_DEFAULT_SEPARATOR, false);
    }

    public static String join(List vObjects, String sSeparator) {
        return CCLStringUtils.join(vObjects, sSeparator, false);
    }

    public static String join(List vObjects, boolean bIgnoreNulls) {
        return CCLStringUtils.join(vObjects, JOIN_DEFAULT_SEPARATOR, bIgnoreNulls);
    }

    public static String join(List vObjects, String sSeparator, boolean bIgnoreNulls) {
        Object[] v = vObjects.toArray();
        return CCLStringUtils.join(v, sSeparator, bIgnoreNulls);
    }

    public static String join(Object[] vObjects) {
        return CCLStringUtils.join(vObjects, JOIN_DEFAULT_SEPARATOR, false);
    }

    public static String join(Object[] vObjects, String sSeparator) {
        return CCLStringUtils.join(vObjects, sSeparator, false);
    }

    public static String join(Object[] vObjects, boolean bIgnoreNulls) {
        return CCLStringUtils.join(vObjects, JOIN_DEFAULT_SEPARATOR, bIgnoreNulls);
    }

    public static String join(Object[] vObjects, String sSeparator, boolean bIgnoreNulls) {
        String sRet = null;
        StringBuffer sb = new StringBuffer(2000);
        boolean bDidOne = false;
        for (int i = 0; i < vObjects.length; ++i) {
            Object objToWrite = vObjects[i];
            boolean bWriteIt = true;
            String sStr = null;
            if (objToWrite == null && bIgnoreNulls) {
                bWriteIt = false;
            }
            if (!bWriteIt) continue;
            sStr = objToWrite == null ? JOIN_NULL_STRING : objToWrite.toString();
            if (bDidOne) {
                sb.append(sSeparator);
            } else {
                bDidOne = true;
            }
            sb.append(sStr);
        }
        sRet = sb.toString();
        return sRet;
    }

    public static String trim(String sOriginal, int nMaxLen) {
        String sRet = sOriginal;
        try {
            CCLCheck.nonNegative(nMaxLen);
            try {
                if (sOriginal.length() > nMaxLen) {
                    StringBuffer sb = new StringBuffer(nMaxLen);
                    int nNewLen = nMaxLen - TRIM_TRAILER_LEN;
                    if (nNewLen >= 0) {
                        sb.append(sOriginal.substring(0, nMaxLen - TRIM_TRAILER_LEN));
                        sb.append(TRIM_TRAILER);
                    }
                    if ((sRet = sb.toString()).length() > nMaxLen) {
                        sRet = sRet.substring(0, nMaxLen);
                    }
                }
            }
            catch (NullPointerException nex) {
                if (sOriginal == null) {
                    throw new CCLRuntimeException(MSG_NULL_MAIN_STRING);
                }
                throw nex;
            }
            catch (Exception ex) {
                throw ex;
            }
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "trimming string");
        }
        return sRet;
    }

    public static String trimExtraWhiteSpace(String strToTokenize) {
        StringBuffer newStr = new StringBuffer(strToTokenize.length());
        StringTokenizer toker = new StringTokenizer(strToTokenize, "\t\n\r ");
        while (toker.hasMoreTokens()) {
            if (newStr.length() > 0) {
                newStr.append(" ");
            }
            newStr.append(toker.nextToken());
        }
        return newStr.toString();
    }

    public static String getExtendedVariable(String sVar) throws UnrecognizedExtendedVariableException {
        String sRet = null;
        try {
            sRet = CCLHTMLEntities.getStringForHTMLEntity(sVar);
        }
        catch (CCLHTMLEntities.UnrecognizedHTMLEntityException hex) {
            // empty catch block
        }
        if (sRet == null && sVar.charAt(0) == 'u' && sVar.length() == 5) {
            String sUniChar = sVar.substring(1);
            char[] vCh = new char[1];
            try {
                vCh[0] = (char)Integer.parseInt(sUniChar, 16);
                sRet = new String(vCh);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (sRet == null) {
            throw new UnrecognizedExtendedVariableException("Unrecognized extended variable: '" + sVar + "'", sVar);
        }
        return sRet;
    }

    public static String replaceAll(String sMainString, String sSearchFor, String sReplacement) {
        return CCLStringUtils.replaceWithLimit(sMainString, sSearchFor, sReplacement, -1);
    }

    public static String replaceFirst(String sMainString, String sSearchFor, String sReplacement) {
        return CCLStringUtils.replaceWithLimit(sMainString, sSearchFor, sReplacement, 1);
    }

    public static String replaceWithLimit(String sMainString, String sSearchFor, String sReplacement, int nMax) {
        StringBuffer sb;
        block8: {
            if (sSearchFor == null || sMainString == null) {
                throw new CCLRuntimeException(MSG_NULL_PARAM);
            }
            if (sSearchFor.length() == 0) {
                throw new CCLRuntimeException(MSG_ZERO_SEARCH_STRING);
            }
            if (sReplacement == null) {
                throw new CCLRuntimeException(MSG_ZERO_REPLACE_STRING);
            }
            if (nMax == 0) {
                return sMainString;
            }
            int nReplacedCount = 0;
            sb = null;
            try {
                int nMainLen = sMainString.length();
                sb = new StringBuffer(nMainLen * 2);
                int nSearchForLen = sSearchFor.length();
                int nIdxStart = 0;
                do {
                    int nIdxFound;
                    if ((nIdxFound = sMainString.indexOf(sSearchFor, nIdxStart)) == -1) {
                        sb.append(sMainString.substring(nIdxStart));
                        break block8;
                    }
                    sb.append(sMainString.substring(nIdxStart, nIdxFound));
                    sb.append(sReplacement);
                    nIdxStart = nIdxFound + nSearchForLen;
                } while (nMax <= 0 || ++nReplacedCount != nMax);
                sb.append(sMainString.substring(nIdxStart));
            }
            catch (Exception ex) {
                throw new CCLRuntimeException(ex, "replacing '" + sSearchFor + "' with '" + sReplacement + "' in '" + sMainString + "'");
            }
        }
        String sRet = sb.toString();
        return sRet;
    }

    public static String[] split(String sMainString, String sDelimiter) {
        return CCLStringUtils.split(sMainString, sDelimiter, false, true);
    }

    public static String[] split(String sMainString, String sDelimiter, boolean bTrim, boolean bIncludeEmpty) {
        String[] vRet = null;
        try {
            try {
                ArrayList v;
                block10: {
                    if (sDelimiter.length() == 0) {
                        throw new CCLRuntimeException(MSG_ZERO_LENGTH_DELIMITER);
                    }
                    v = new ArrayList(50);
                    int nSeparatorLen = sDelimiter.length();
                    int nIdxStart = 0;
                    int nIdxFound = sMainString.indexOf(sDelimiter, nIdxStart);
                    if (nIdxFound > -1) {
                        while (true) {
                            if (nIdxFound == -1) {
                                CCLStringUtils.addToSplitList(v, sMainString.substring(nIdxStart), bTrim, bIncludeEmpty);
                                break block10;
                            }
                            CCLStringUtils.addToSplitList(v, sMainString.substring(nIdxStart, nIdxFound), bTrim, bIncludeEmpty);
                            nIdxStart = nIdxFound + nSeparatorLen;
                            nIdxFound = sMainString.indexOf(sDelimiter, nIdxStart);
                        }
                    }
                    CCLStringUtils.addToSplitList(v, sMainString, bTrim, bIncludeEmpty);
                }
                vRet = new String[v.size()];
                v.toArray(vRet);
            }
            catch (NullPointerException ex) {
                if (sMainString == null) {
                    throw new CCLRuntimeException(MSG_NULL_MAIN_STRING);
                }
                if (sDelimiter == null) {
                    throw new CCLRuntimeException(MSG_NULL_DELIMITER_STRING);
                }
                throw ex;
            }
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "splitting by '" + sDelimiter + "' in '" + sMainString + "'");
        }
        return vRet;
    }

    private static void addToSplitList(ArrayList vList, String sToken, boolean bTrim, boolean bIncludeEmpty) {
        String s = sToken;
        if (bTrim) {
            s = s.trim();
        }
        if (!bIncludeEmpty && s.length() == 0) {
            s = null;
        }
        if (s != null) {
            vList.add(s);
        }
    }

    public static String replace(String sOriginal, Map mVars) {
        return CCLStringUtils.replace(sOriginal, mVars, DEFAULT_START_MARKER, DEFAULT_END_MARKER, true);
    }

    public static String replace(String sOriginal, Map mVars, boolean bStrict) {
        return CCLStringUtils.replace(sOriginal, mVars, DEFAULT_START_MARKER, DEFAULT_END_MARKER, bStrict);
    }

    public static String replace(String sOriginal, Map mVars, String sStartMarker, String sEndMarker) {
        return CCLStringUtils.replace(sOriginal, mVars, sStartMarker, sEndMarker, true);
    }

    public static String replace(String sOriginal, Map mVars, String sStartMarker) {
        return CCLStringUtils.replace(sOriginal, mVars, sStartMarker, sStartMarker);
    }

    public static String replace(String sOriginal, Map mVars, String sStartMarker, String sEndMarker, boolean bStrict) {
        String sRet = null;
        try {
            try {
                int nLen = sOriginal.length();
                int nLongerLen = nLen + nLen;
                StringBuffer sb = new StringBuffer(nLongerLen);
                int nStartMarkerLen = sStartMarker.length();
                int nEndMarkerLen = sEndMarker.length();
                if (nStartMarkerLen == 0 || nEndMarkerLen == 0) {
                    throw new CCLRuntimeException(MSG_ZERO_LENGTH_DELIMITER);
                }
                int nIdx_OldStart = 0;
                while (true) {
                    int nIdx_End;
                    int nIdx_Start;
                    int nIdx_MarkerStart = nIdx_Start = sOriginal.indexOf(sStartMarker, nIdx_OldStart);
                    if (nIdx_Start == -1) break;
                    if (nIdx_Start > nIdx_OldStart) {
                        sb.append(sOriginal.substring(nIdx_OldStart, nIdx_Start));
                    }
                    if ((nIdx_End = sOriginal.indexOf(sEndMarker, nIdx_Start += nStartMarkerLen)) == -1) {
                        if (bStrict) {
                            String sMsg = "missing end-delimiter '" + sEndMarker + "' for variable starting at " + nIdx_Start;
                            throw new CCLRuntimeException(sMsg);
                        }
                        sb.append(sStartMarker.charAt(0));
                        nIdx_OldStart = nIdx_MarkerStart + 1;
                        continue;
                    }
                    String sVar = sOriginal.substring(nIdx_Start, nIdx_End);
                    String sValue = null;
                    try {
                        sValue = (String)mVars.get(sVar);
                    }
                    catch (NullPointerException nex) {
                        throw nex;
                    }
                    catch (Exception ex) {
                        throw new CCLRuntimeException(ex, "getting variable '" + sVar + "' from map");
                    }
                    if (sValue == null) {
                        if (bStrict) {
                            String sMsg = "variable is not in map: variable '" + sVar + "' starting at " + nIdx_Start + " and ending at " + nIdx_End;
                            throw new CCLRuntimeException(sMsg);
                        }
                        sb.append(sStartMarker.charAt(0));
                        nIdx_OldStart = nIdx_MarkerStart + 1;
                        continue;
                    }
                    sb.append(sValue);
                    nIdx_OldStart = nIdx_End + nEndMarkerLen;
                }
                if (nIdx_OldStart < nLen) {
                    sb.append(sOriginal.substring(nIdx_OldStart));
                }
                sRet = sb.toString();
            }
            catch (NullPointerException nex) {
                if (sOriginal == null) {
                    throw new CCLRuntimeException(MSG_NULL_MAIN_STRING);
                }
                if (mVars == null) {
                    throw new CCLRuntimeException(MSG_NULL_REPLACEMENT_MAP);
                }
                if (sStartMarker == null || sEndMarker == null) {
                    throw new CCLRuntimeException(MSG_NULL_DELIMITER_STRING);
                }
                throw nex;
            }
            catch (Exception ex) {
                if (sStartMarker.length() == 0 || sEndMarker.length() == 0) {
                    throw (CCLRuntimeException)ex;
                }
                throw ex;
            }
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "replacing variables in '" + CCLStringUtils.trim(sOriginal, 50) + "'");
        }
        return sRet;
    }

    public static class ExtendedVariablesReplacementMap
    extends ReplacementMapAdapter {
        Map _mMainMap;

        public ExtendedVariablesReplacementMap(Map mMainMap) {
            this._mMainMap = mMainMap;
        }

        @Override
        public Object get(Object objKey) {
            String sRet = (String)this._mMainMap.get(objKey);
            if (sRet == null) {
                String sKey = (String)objKey;
                sRet = CCLStringUtils.getExtendedVariable(sKey);
            }
            return sRet;
        }
    }

    public static abstract class ReplacementMapAdapter
    implements Map {
        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public abstract Object get(Object var1);

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Set keySet() {
            throw new UnsupportedOperationException();
        }

        public Collection values() {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    }

    public static class UnrecognizedExtendedVariableException
    extends CCLRuntimeException {
        static final long serialVersionUID = 1739271510147388409L;
        private String _sVariable;

        UnrecognizedExtendedVariableException(String sMsg, String sVariable) {
            super(sMsg);
            this._sVariable = sVariable;
        }

        public String getVariable() {
            return this._sVariable;
        }
    }
}

