/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.util;

import com.cognos.ccl4j.util.CCLShellUtils;

public class CCLTimingUtils {
    private static boolean _bLibraryLoaded = false;
    private static boolean _bLibraryAvailable = false;
    private static double _nTicksPerSec = 0.0;
    private static double _nTicksMult = 1.0;
    private static long _nTicksAtStartup = 0L;
    private static boolean _bInitDone = false;
    public static String DEFAULT_JNI_LIB = "CCL4J_JNI";

    public static void initialize() {
        CCLTimingUtils.initialize(DEFAULT_JNI_LIB);
    }

    public static synchronized void initialize(String sLibraryName) {
        if (!_bInitDone) {
            _bInitDone = true;
            if (CCLShellUtils.isWin32Platform()) {
                if (!_bLibraryLoaded) {
                    CCLTimingUtils.loadLibrary(sLibraryName);
                }
                if (_bLibraryAvailable) {
                    _nTicksPerSec = CCLTimingUtils.getTicksPerSec();
                    _nTicksMult = 1000.0 / _nTicksPerSec;
                }
            }
            _nTicksAtStartup = CCLTimingUtils.getTicks();
        }
    }

    private static void loadLibrary(String sLibraryName) {
        if (!_bLibraryLoaded) {
            _bLibraryLoaded = true;
            String sLib = sLibraryName;
            if (sLib == null || "".equals(sLib)) {
                sLib = DEFAULT_JNI_LIB;
            }
            try {
                System.loadLibrary(sLib);
                _bLibraryAvailable = true;
            }
            catch (UnsatisfiedLinkError exLink) {
                System.out.println("CCL: failed to load " + sLib + " (" + System.mapLibraryName(sLib) + ")");
                exLink.printStackTrace(System.out);
            }
            catch (SecurityException exLink) {
                System.out.println("CCL: failed to load " + sLib + " (" + System.mapLibraryName(sLib) + ")");
                exLink.printStackTrace(System.out);
            }
        }
    }

    public static long getTicks() {
        long nTicks = 0L;
        if (_bLibraryAvailable) {
            try {
                nTicks = CCLTimingUtils.getSystemTicks();
            }
            catch (Throwable th) {
                System.out.println("Caught throwable in getTicks()");
                th.printStackTrace(System.out);
            }
        }
        if (nTicks == 0L) {
            nTicks = System.currentTimeMillis();
        }
        return nTicks;
    }

    public static long getTicksSinceStartup() {
        long nRet = CCLTimingUtils.getTicks() - _nTicksAtStartup;
        return nRet;
    }

    public static double getMillisSinceStartup() {
        double nRet = CCLTimingUtils.ticksToMillis(CCLTimingUtils.getTicksSinceStartup());
        return nRet;
    }

    public static long getTicksPerSec() {
        long nTicksPerSec = 0L;
        if (_bLibraryAvailable) {
            try {
                nTicksPerSec = CCLTimingUtils.getSystemTicksPerSec();
            }
            catch (Throwable th) {
                System.out.println("Caught throwable in getTicks()");
                th.printStackTrace(System.out);
            }
        }
        if (nTicksPerSec == 0L) {
            nTicksPerSec = 1000L;
        }
        return nTicksPerSec;
    }

    public static double ticksToMillis(long nTicks) {
        return (double)nTicks * _nTicksMult;
    }

    public static double ticksToMillis(double nTicks) {
        return nTicks * _nTicksMult;
    }

    private static native long getSystemTicks() throws CCLExtException;

    private static native long getSystemTicksPerSec() throws Exception;

    public class CCLExtException
    extends Exception {
        public CCLExtException() {
        }

        public CCLExtException(String msg) {
            super(msg);
        }
    }
}

