/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.util;

import java.io.Serializable;
import java.security.SecureRandom;

public final class CCLUUID
implements Serializable,
Comparable {
    static final long serialVersionUID = 512958951622248677L;
    public static final String NAMESPACE_DNS = "6ba7b810-9dad-11d1-80b4-00c04fd430c8";
    public static final String NAMESPACE_URL = "6ba7b811-9dad-11d1-80b4-00c04fd430c8";
    public static final String NAMESPACE_OID = "6ba7b812-9dad-11d1-80b4-00c04fd430c8";
    public static final String NAMESPACE_X500 = "6ba7b814-9dad-11d1-80b4-00c04fd430c8";
    private static final CCLUUID _nullUUID = new CCLUUID(0L, 0L);
    private final long _mostSigBits;
    private final long _leastSigBits;
    private transient int _hashCode = -1;
    private static volatile SecureRandom numberGenerator = new SecureRandom();

    public CCLUUID(long mostSigBits, long leastSigBits) {
        this._mostSigBits = mostSigBits;
        this._leastSigBits = leastSigBits;
    }

    public CCLUUID(byte[] data) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        this._mostSigBits = msb;
        this._leastSigBits = lsb;
    }

    public CCLUUID(String id) throws NumberFormatException {
        try {
            long msb = 0L;
            long lsb = 0L;
            int nIdxString = 0;
            int nIdxOut = 0;
            while (nIdxString < 36) {
                switch (nIdxString) {
                    case 8: 
                    case 13: 
                    case 18: 
                    case 23: {
                        if (id.charAt(nIdxString) != '-') {
                            throw new NumberFormatException("UUID has to be represented by the standard 36-char representation");
                        }
                        ++nIdxString;
                    }
                }
                char c = id.charAt(nIdxString);
                byte b = 0;
                if (c >= '0' && c <= '9') {
                    b = (byte)(c - 48);
                } else if (c >= 'a' && c <= 'f') {
                    b = (byte)(c - 97 + 10);
                } else if (c >= 'A' && c <= 'F') {
                    b = (byte)(c - 65 + 10);
                } else {
                    throw new NumberFormatException("Non-hex character '" + c + "'");
                }
                if (nIdxOut < 16) {
                    msb <<= 4;
                    msb |= (long)b;
                } else {
                    lsb <<= 4;
                    lsb |= (long)b;
                }
                ++nIdxString;
                ++nIdxOut;
            }
            this._mostSigBits = msb;
            this._leastSigBits = lsb;
        }
        catch (NumberFormatException ex) {
            if (id.length() != 36) {
                throw new NumberFormatException("UUID has to be represented by the standard 36-char representation");
            }
            throw ex;
        }
    }

    public long getMostSignificantBits() {
        return this._mostSigBits;
    }

    public long getLeastSignificantBits() {
        return this._leastSigBits;
    }

    public int hashCode() {
        if (this._hashCode == -1) {
            this._hashCode = (int)(this._mostSigBits >> 32 ^ this._mostSigBits ^ this._leastSigBits >> 32 ^ this._leastSigBits);
        }
        return this._hashCode;
    }

    public static CCLUUID getNullUUID() {
        return _nullUUID;
    }

    public boolean isNullUUID() {
        boolean bRet = false;
        if (this._mostSigBits == 0L && this._leastSigBits == 0L) {
            bRet = true;
        }
        return bRet;
    }

    public String toString() {
        String sRet = CCLUUID.digits(this._mostSigBits >> 32, 8) + "-" + CCLUUID.digits(this._mostSigBits >> 16, 4) + "-" + CCLUUID.digits(this._mostSigBits, 4) + "-" + CCLUUID.digits(this._leastSigBits >> 48, 4) + "-" + CCLUUID.digits(this._leastSigBits, 12);
        return sRet;
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public int compareTo(Object o) {
        if (!(o instanceof CCLUUID)) {
            return -1;
        }
        CCLUUID other = (CCLUUID)o;
        if (this._mostSigBits < other._mostSigBits) {
            return -1;
        }
        if (this._mostSigBits > other._mostSigBits) {
            return 1;
        }
        if (this._leastSigBits < other._leastSigBits) {
            return -1;
        }
        if (this._leastSigBits > other._leastSigBits) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CCLUUID)) {
            return false;
        }
        CCLUUID other = (CCLUUID)o;
        return other._mostSigBits == this._mostSigBits && other._leastSigBits == this._leastSigBits;
    }

    public static CCLUUID newRandomUUID() {
        SecureRandom ng = numberGenerator;
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        return new CCLUUID(randomBytes);
    }
}

