/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.autoca.CaServer;
import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapperException;
import com.cognos.accman.jcam.crypto.misc.IPFAuditFunction;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.SANExtAttributes;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class CryptoWrapper {
    private static final String COGNOS_OID = "1.2.840.114050";
    private static final String PKCS10_CLIENT_IP_ADDR_OID = "1.2.840.114050.77";
    public static final int INT_ARRAY_LENGTH = 4;

    public static byte[] encodeBase64(byte[] data) {
        return Base64.encode((byte[])data);
    }

    public static byte[] decodeBase64(byte[] base64data) {
        return Base64.decode((byte[])base64data);
    }

    private static void addSANExtensionToCertificate(PKCS10CertificationRequest csr, X509V3CertificateGenerator x509gen) {
        ASN1Set attrs = csr.getCertificationRequestInfo().getAttributes();
        if (attrs != null) {
            for (int a = 0; a < attrs.size(); ++a) {
                Attribute attr = Attribute.getInstance((Object)attrs.getObjectAt(a));
                ASN1ObjectIdentifier attrType = attr.getAttrType();
                ASN1Set attrValues = attr.getAttrValues();
                if (!attrType.equals((Object)PKCSObjectIdentifiers.pkcs_9_at_extensionRequest) || attrValues.size() < 1) continue;
                X509Extensions csrExts = new X509Extensions((ASN1Sequence)attrValues.getObjectAt(0));
                Enumeration oids = csrExts.oids();
                while (oids.hasMoreElements()) {
                    ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)oids.nextElement();
                    if (!oid.equals((Object)X509Extensions.SubjectAlternativeName)) continue;
                    X509Extension x509Ext = csrExts.getExtension(oid);
                    boolean critical = x509Ext.isCritical();
                    x509gen.addExtension(oid, critical, (ASN1Encodable)X509Extension.convertValueToObject((X509Extension)x509Ext));
                }
            }
        }
    }

    public static Certificate generateCertificate(byte[] pkcs10data, Certificate caCert, PrivateKey caKey) throws CryptoWrapperException {
        Certificate requestedCert;
        Configuration config = Configuration.getInstance();
        ByteArrayInputStream bPKCS10In = new ByteArrayInputStream(pkcs10data);
        ASN1InputStream dPKCS10In = new ASN1InputStream((InputStream)bPKCS10In);
        String originatingIPAddrStr = "UNKNOWN IP";
        String failMsg = null;
        String subject = null;
        try {
            long caCertLifetime;
            ASN1Primitive pkcs10Sequence = dPKCS10In.readObject();
            PKCS10CertificationRequest csr = new PKCS10CertificationRequest(pkcs10Sequence.getEncoded());
            boolean v = csr.verify();
            if (!v) {
                throw new CryptoWrapperException(MessageSet.getMessage("CAM_CRP_invalid_cert_req"));
            }
            ASN1Set attrs = csr.getCertificationRequestInfo().getAttributes();
            if (attrs != null) {
                for (int a = 0; a < attrs.size(); ++a) {
                    ASN1Encodable attrValue;
                    Attribute attr = Attribute.getInstance((Object)attrs.getObjectAt(a));
                    ASN1ObjectIdentifier attrType = attr.getAttrType();
                    ASN1Set attrValues = attr.getAttrValues();
                    if (!attrType.toString().equals(PKCS10_CLIENT_IP_ADDR_OID) || attrValues.size() != 1 || !((attrValue = attr.getAttrValues().getObjectAt(0)).toASN1Primitive() instanceof DEROctetString)) continue;
                    byte[] ipAddr = ((DEROctetString)attrValue.toASN1Primitive()).getOctets();
                    if (ipAddr.length == 4) {
                        originatingIPAddrStr = (ipAddr[0] & 0xFF) + "." + (ipAddr[1] & 0xFF) + "." + (ipAddr[2] & 0xFF) + "." + (ipAddr[3] & 0xFF);
                        continue;
                    }
                    originatingIPAddrStr = "";
                    for (int b = 0; b < ipAddr.length; ++b) {
                        originatingIPAddrStr = originatingIPAddrStr + Integer.toHexString(ipAddr[b] & 0xFF);
                        originatingIPAddrStr = originatingIPAddrStr + Integer.toHexString(ipAddr[++b] & 0xFF);
                        originatingIPAddrStr = originatingIPAddrStr + ":";
                    }
                }
            }
            subject = csr.getCertificationRequestInfo().getSubject().toString();
            ByteArrayInputStream bCACertIn = null;
            try {
                bCACertIn = new ByteArrayInputStream(caCert.getEncoded());
            }
            catch (CertificateEncodingException cee) {
                failMsg = MessageSet.getMessage("CAM_CRP_autoca_bad_response_log", new String[]{originatingIPAddrStr, subject, "CAM_CRP_invalid_ca_cert_from_keystore"});
                IPFAuditFunction.trace(failMsg);
                throw new CryptoWrapperException(MessageSet.getMessage("CAM_CRP_invalid_ca_cert_from_keystore"));
            }
            ASN1InputStream dCACertIn = new ASN1InputStream((InputStream)bCACertIn);
            ASN1Primitive caCertSequence = dCACertIn.readObject();
            X509CertificateStructure bcCaCert = X509CertificateStructure.getInstance((Object)ASN1Primitive.fromByteArray((byte[])caCertSequence.getEncoded()));
            X509V3CertificateGenerator x509gen = new X509V3CertificateGenerator();
            String digestAlgorithm = config.getDigestAlgorithm();
            String signatureAlgorithm = Configuration.getSignatureAlgorithm(digestAlgorithm, caKey.getAlgorithm());
            x509gen.setSignatureAlgorithm(signatureAlgorithm);
            try {
                caCertLifetime = config.getCANewCertificateLifetime();
            }
            catch (CAMCryptoException ce) {
                failMsg = MessageSet.getMessage("CAM_CRP_autoca_bad_response_log", new String[]{originatingIPAddrStr, subject, "CAM_CRP_gen_new_cert"});
                IPFAuditFunction.trace(failMsg);
                throw new CryptoWrapperException(ce, MessageSet.getMessage("CAM_CRP_gen_new_cert"));
            }
            Date currentDate = new Date();
            Date expiryDate = new Date(currentDate.getTime() + caCertLifetime * 86400000L);
            Date startDate = new Date(currentDate.getTime() - 172800000L);
            x509gen.setNotBefore(startDate);
            x509gen.setNotAfter(expiryDate);
            x509gen.setIssuerDN((X509Name)new X509Principal(bcCaCert.getSubject()));
            x509gen.setPublicKey(csr.getPublicKey());
            x509gen.setSubjectDN((X509Name)new X509Principal(csr.getCertificationRequestInfo().getSubject()));
            x509gen.setSerialNumber(CaServer.getNextCertSerial());
            DERSequence basicConstrExtVal = new DERSequence();
            x509gen.addExtension("2.5.29.19", false, (ASN1Encodable)basicConstrExtVal);
            CryptoWrapper.addSANExtensionToCertificate(csr, x509gen);
            X509Certificate requestedBCCert = x509gen.generate(caKey);
            CertificateFactory certFactory = null;
            String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
            certFactory = JVMEnvironment.getInstance().isFIPSEnabled() ? CertificateFactory.getInstance(requestedBCCert.getType(), jceProvider) : CertificateFactory.getInstance(requestedBCCert.getType());
            ByteArrayInputStream bais = new ByteArrayInputStream(requestedBCCert.getEncoded());
            requestedCert = certFactory.generateCertificate(bais);
            String shaAlg = config.getDigestAlgorithm();
            MessageDigest thumbprintMD = null;
            thumbprintMD = JVMEnvironment.getInstance().isFIPSEnabled() ? MessageDigest.getInstance(shaAlg, jceProvider) : MessageDigest.getInstance(shaAlg);
            byte[] thumbprint = thumbprintMD.digest(requestedCert.getEncoded());
            StringBuffer thumbprintStr = new StringBuffer(thumbprint.length * 2 + 19);
            for (int b = 0; b < thumbprint.length; ++b) {
                if (b != 0) {
                    thumbprintStr.append(':');
                }
                thumbprintStr.append(Integer.toHexString(thumbprint[b] & 0xFF));
            }
        }
        catch (Exception e) {
            failMsg = MessageSet.getMessage("CAM_CRP_autoca_bad_response_log", new String[]{originatingIPAddrStr, subject, "CAM_CRP_gen_new_cert"});
            IPFAuditFunction.trace(failMsg);
            throw new CryptoWrapperException(e, MessageSet.getMessage("CAM_CRP_gen_new_cert"));
        }
        return requestedCert;
    }

    public static byte[] calculateHMAC(byte[] content, String password) throws CryptoWrapperException {
        byte[] out;
        Configuration config = Configuration.getInstance();
        try {
            String hmacAlg = config.getHMACAlgorithm();
            SecretKeySpec key = new SecretKeySpec(password.getBytes(), hmacAlg);
            String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
            Mac mac = Mac.getInstance(hmacAlg, jceProvider);
            mac.init(key);
            mac.update(content);
            out = mac.doFinal();
        }
        catch (Exception e) {
            throw new CryptoWrapperException(e, MessageSet.getMessage("CAM_CRP_gen_HMAC"));
        }
        return out;
    }

    public static byte[] calculateHMAC(byte[] content, String password, String hmacAlgorithm) throws CryptoWrapperException {
        byte[] out;
        Configuration config = Configuration.getInstance();
        try {
            SecretKeySpec key = new SecretKeySpec(password.getBytes(), hmacAlgorithm);
            String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
            Mac mac = Mac.getInstance(hmacAlgorithm, jceProvider);
            mac.init(key);
            mac.update(content);
            out = mac.doFinal();
        }
        catch (Exception e) {
            throw new CryptoWrapperException(e, MessageSet.getMessage("CAM_CRP_gen_HMAC"));
        }
        return out;
    }

    public static byte[] createCertificateRequest(String subjectDN, PublicKey publicKey, PrivateKey reqSigningKey, String digestAlgorithm, SANExtAttributes sanExtAttrs) throws CryptoWrapperException {
        X509Name x509Subject;
        byte[] hostIP;
        Configuration config = Configuration.getInstance();
        try {
            hostIP = InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException e) {
            throw new CryptoWrapperException(e, MessageSet.getMessage("CAM_CRP_create_PKCS10_req"));
        }
        ASN1EncodableVector attributeVect = new ASN1EncodableVector();
        DEROctetString ipBytes = new DEROctetString(hostIP);
        Attribute ipAttribute = new Attribute(new ASN1ObjectIdentifier(PKCS10_CLIENT_IP_ADDR_OID), (ASN1Set)new DERSet((ASN1Encodable)ipBytes));
        attributeVect.add((ASN1Encodable)ipAttribute);
        ArrayList<GeneralName> subjAltNames = new ArrayList<GeneralName>();
        if (sanExtAttrs == null) {
            sanExtAttrs = new SANExtAttributes(config.getSanDnsNames(), config.getSanEmailAddrs(), config.getSanIPAddrs());
        }
        CryptoWrapper.addSanAttrs(subjAltNames, 2, sanExtAttrs.getDNSNameValues());
        CryptoWrapper.addSanAttrs(subjAltNames, 1, sanExtAttrs.getEmailValues());
        CryptoWrapper.addSanAttrs(subjAltNames, 7, sanExtAttrs.getIPAddressValues());
        if (subjAltNames.size() > 0) {
            try {
                int generalNameSize = subjAltNames.size();
                GeneralName[] generalNames = new GeneralName[generalNameSize];
                for (int i = 0; i < generalNameSize; ++i) {
                    generalNames[i] = (GeneralName)subjAltNames.get(i);
                }
                GeneralNames subjAltName = new GeneralNames(generalNames);
                Vector<ASN1ObjectIdentifier> oids = new Vector<ASN1ObjectIdentifier>();
                Vector<X509Extension> values = new Vector<X509Extension>();
                oids.add(X509Extensions.SubjectAlternativeName);
                values.add(new X509Extension(false, (ASN1OctetString)new DEROctetString((ASN1Encodable)subjAltName)));
                X509Extensions extensions = new X509Extensions(oids, values);
                Attribute sanAttribute = new Attribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Set)new DERSet((ASN1Encodable)extensions));
                attributeVect.add((ASN1Encodable)sanAttribute);
            }
            catch (IOException e) {
                throw new CryptoWrapperException(e, MessageSet.getMessage("CAM_CRP_create_PKCS10_req"));
            }
        }
        DERSet attribs = new DERSet(attributeVect);
        try {
            x509Subject = new X509Name(CAMCryptoUtilities.reverseDN(subjectDN));
        }
        catch (IllegalArgumentException e) {
            throw new CryptoWrapperException(e, MessageSet.getMessage("CAM_CRP_bad_subject_DN"));
        }
        DEROctetString s = null;
        try {
            String signatureAlgorithm = Configuration.getSignatureAlgorithm(digestAlgorithm, publicKey.getAlgorithm());
            PKCS10CertificationRequest csr = new PKCS10CertificationRequest(signatureAlgorithm, x509Subject, publicKey, (ASN1Set)attribs, reqSigningKey);
            s = new DEROctetString((ASN1Encodable)csr.toASN1Primitive());
        }
        catch (Exception e) {
            throw new CryptoWrapperException(e, MessageSet.getMessage("CAM_CRP_create_PKCS10_req"));
        }
        return s.getOctets();
    }

    private static void addSanAttrs(List<GeneralName> subjAltNames, int name, String[] values) {
        if (values != null) {
            for (String aValue : values) {
                if (aValue.isEmpty()) continue;
                GeneralName genName = new GeneralName(name, aValue);
                subjAltNames.add(genName);
            }
        }
    }

    public static X509Certificate createSelfSignedCertificate(KeyPair keyPair, String subjectDN, String digestAlgorithm, long lifetime) throws CryptoWrapperException {
        X509Certificate x509cert;
        X509V3CertificateGenerator X509gen;
        try {
            X509Name dn = new X509Name(subjectDN);
            X509gen = new X509V3CertificateGenerator();
            Configuration config = Configuration.getInstance();
            if (digestAlgorithm == null) {
                digestAlgorithm = config.getDigestAlgorithm();
            }
            String signatureAlgorithm = Configuration.getSignatureAlgorithm(digestAlgorithm, keyPair.getPrivate().getAlgorithm());
            X509gen.setSignatureAlgorithm(signatureAlgorithm);
            long caCertLifetime = lifetime;
            try {
                if (lifetime == -1L) {
                    caCertLifetime = config.getCASelfSignedCertLifetime();
                }
            }
            catch (CAMCryptoException ce) {
                throw new CryptoWrapperException(ce, MessageSet.getMessage("CAM_CRP_gen_new_cert"));
            }
            Date currentDate = new Date();
            Date expiryDate = new Date(currentDate.getTime() + caCertLifetime * 86400000L);
            Date startDate = new Date(currentDate.getTime() - 172800000L);
            X509gen.setNotBefore(startDate);
            X509gen.setNotAfter(expiryDate);
            X509gen.setIssuerDN(dn);
            X509gen.setPublicKey(keyPair.getPublic());
            X509gen.setSubjectDN(dn);
            X509gen.setSerialNumber(CaServer.getNextCertSerial());
            DERSequence basicConstrExtVal = new DERSequence((ASN1Encodable)new DERBoolean(true));
            X509gen.addExtension("2.5.29.19", true, (ASN1Encodable)basicConstrExtVal);
        }
        catch (Exception e) {
            throw new CryptoWrapperException(e, MessageSet.getMessage("CAM_CRP_gen_new_cert"));
        }
        try {
            x509cert = X509gen.generate(keyPair.getPrivate());
        }
        catch (InvalidKeyException e) {
            throw new CryptoWrapperException(e, MessageSet.getMessage("CAM_CRP_gen_new_cert"));
        }
        catch (GeneralSecurityException e) {
            throw new CryptoWrapperException(e, MessageSet.getMessage("CAM_CRP_gen_new_cert"));
        }
        return x509cert;
    }

    public static X509Certificate decodeCert(byte[] encodedCert) throws CryptoWrapperException, CertificateParsingException {
        X509Certificate x509Cert = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream is = new ByteArrayInputStream(encodedCert);
            x509Cert = (X509Certificate)cf.generateCertificate(is);
        }
        catch (CertificateException e) {
            throw new CryptoWrapperException(e, MessageSet.getMessage("CAM_CRP_no_decode_cert"));
        }
        return x509Cert;
    }

    public static final int toInt(byte[] byteArray) {
        int val = 0;
        int len = 4;
        for (int i = len - 1; i >= 0; --i) {
            val <<= 8;
            val |= byteArray[i] & 0xFF;
        }
        return val;
    }

    public static final byte[] toByteArray(int intVal) {
        byte[] byteArray = new byte[4];
        CryptoWrapper.toByteArray(intVal, byteArray, 0, 4);
        return byteArray;
    }

    public static final int toInt(byte[] byteArray, int offset, int len) {
        int val = 0;
        len = Math.min(len, 4);
        for (int i = len - 1; i >= 0; --i) {
            val <<= 8;
            val |= byteArray[offset + i] & 0xFF;
        }
        return val;
    }

    public static long toLong(byte[] byteArray, int len) {
        long val = 0L;
        for (int i = len - 1; i >= 0; --i) {
            val <<= 8;
            val |= (long)(byteArray[i] & 0xFF);
        }
        return val;
    }

    public static long toLong(byte[] b) {
        return ((long)b[7] & 0xFFL) + (((long)b[6] & 0xFFL) << 8) + (((long)b[5] & 0xFFL) << 16) + (((long)b[4] & 0xFFL) << 24) + (((long)b[3] & 0xFFL) << 32) + (((long)b[2] & 0xFFL) << 40) + (((long)b[1] & 0xFFL) << 48) + (((long)b[0] & 0xFFL) << 56);
    }

    public static final void toByteArray(int intVal, byte[] byteArray, int offset, int len) {
        int max = offset + len;
        for (int i = offset; i < max; ++i) {
            byteArray[i] = (byte)intVal;
            intVal >>>= 8;
        }
    }

    public static final void toByteArray(int intVal, byte[] byteArray) {
        CryptoWrapper.toByteArray(intVal, byteArray, 0, 4);
    }

    public static final byte[] toByteArray(long longVal, int offset, int len) {
        int max = offset + len;
        byte[] byteArray = new byte[8];
        for (int i = offset; i < max; ++i) {
            byteArray[i] = (byte)longVal;
            longVal >>>= 8;
        }
        return byteArray;
    }

    public static final byte[] toByteArray(long longVal, int offset) {
        byte[] byteArray = new byte[8];
        int bits = 64;
        for (int i = 0; i < 8; ++i) {
            byteArray[offset + i] = (byte)(longVal >> (bits -= 8) & 0xFFL);
        }
        return byteArray;
    }

    public static byte[] addParity(byte[] in) {
        byte[] result = new byte[8];
        int resultIx = 1;
        int bitCount = 0;
        for (int i = 0; i < 56; ++i) {
            boolean bit;
            boolean bl = bit = (in[6 - i / 8] & 1 << i % 8) > 0;
            if (bit) {
                int n = 7 - resultIx / 8;
                result[n] = (byte)(result[n] | 1 << resultIx % 8 & 0xFF);
                ++bitCount;
            }
            if ((i + 1) % 7 == 0) {
                if (bitCount % 2 == 0) {
                    int n = 7 - resultIx / 8;
                    result[n] = (byte)(result[n] | 1);
                }
                ++resultIx;
                bitCount = 0;
            }
            ++resultIx;
        }
        return result;
    }

    public static byte[] encodeBase16(byte[] bytes) {
        byte[] HEX_CHARS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        byte[] res = new byte[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            res[i * 2] = HEX_CHARS[(bytes[i] & 0xF0) >> 4];
            res[i * 2 + 1] = HEX_CHARS[bytes[i] & 0xF];
        }
        return res;
    }

    public static byte[] decodeBase16(byte[] hex) {
        int hexLen = hex.length;
        byte[] res = new byte[hexLen / 2];
        int r = -1;
        int i = 0;
        while (i + 1 < hexLen) {
            byte h1 = hex[i];
            byte h2 = hex[i + 1];
            if (CryptoWrapper.isHexDigit(h1) && CryptoWrapper.isHexDigit(h2)) {
                r = h1 >= 48 && h1 <= 57 ? h1 - 48 << 4 : (h1 >= 97 && h1 <= 102 ? 10 + h1 - 97 << 4 : 10 + h1 - 65 << 4);
                r = h2 >= 48 && h2 <= 57 ? (r += h2 - 48) : (h2 >= 97 && h2 <= 102 ? (r += 10 + h2 - 97) : (r += 10 + h2 - 65));
                res[i / 2] = (byte)r;
            }
            i += 2;
        }
        return res;
    }

    public static boolean isHexDigit(int ch) {
        return ch >= 97 && ch <= 102 || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90;
    }
}

