/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.IPFAuditFunction;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.accman.res.MessageSet;

public class EncodedCSK_HMAC_Digest {
    private byte[] cskDigest;
    private byte[] hmacDigest;
    static IPFTraceLogger cskTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.CSK");

    public EncodedCSK_HMAC_Digest(byte[] cskDigest, byte[] hmacDigest) throws CAMCryptoException {
        cskTraceLogger.logEnter();
        cskTraceLogger.trace("cskDigest = " + IPFTraceLogger.toBase64String(cskDigest));
        cskTraceLogger.trace("hmacDigest = " + IPFTraceLogger.toBase64String(hmacDigest));
        this.cskDigest = cskDigest;
        this.hmacDigest = hmacDigest;
        cskTraceLogger.logExit(true);
    }

    public EncodedCSK_HMAC_Digest(byte[] encodedCSK_HMAC_Digest, int expectedHMACDigestLength) throws CAMCryptoException {
        cskTraceLogger.logEnter();
        cskTraceLogger.trace("encodedCSK_HMAC_Digest = " + IPFTraceLogger.toBase64String(encodedCSK_HMAC_Digest));
        cskTraceLogger.trace("expectedHMACDigestLength = " + expectedHMACDigestLength);
        this.decodeHMACDigest(encodedCSK_HMAC_Digest, expectedHMACDigestLength);
        cskTraceLogger.logExit(true);
    }

    public byte[] getEncodedHMACDigest() throws CAMCryptoException {
        return this.encodeHMACDigest();
    }

    public byte[] getCSKDigest() {
        return this.cskDigest;
    }

    public byte[] getHMACDigest() {
        return this.hmacDigest;
    }

    private byte[] encodeHMACDigest() throws CAMCryptoException {
        cskTraceLogger.logEnter();
        int cskDigestLength = CAMCryptoUtilities.getCSKDigestLength();
        byte[] encodedHmac = new byte[this.hmacDigest.length + cskDigestLength + 4];
        for (int i = 0; i < 4; ++i) {
            encodedHmac[i] = (byte)(cskDigestLength >> 8 * i & 0xFF);
        }
        System.arraycopy(this.cskDigest, 0, encodedHmac, 4, cskDigestLength);
        System.arraycopy(this.hmacDigest, 0, encodedHmac, 4 + cskDigestLength, this.hmacDigest.length);
        cskTraceLogger.logExit(true);
        return encodedHmac;
    }

    private void decodeHMACDigest(byte[] encodedDigest, int expectedHMACDigestLength) throws CAMCryptoException {
        cskTraceLogger.logEnter();
        cskTraceLogger.trace("encodedDigest = " + IPFTraceLogger.toBase64String(encodedDigest));
        cskTraceLogger.trace("expectedHMACDigestLength = " + expectedHMACDigestLength);
        if (encodedDigest.length < 4) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_gen_HMAC"));
        }
        int cskDigestLength = 0;
        for (int i = 0; i < 4; ++i) {
            cskDigestLength |= encodedDigest[i] << i * 8;
        }
        int expectedCSKDigestLength = encodedDigest.length - expectedHMACDigestLength - 4;
        if (cskDigestLength < 0 || cskDigestLength > expectedCSKDigestLength) {
            IPFAuditFunction.trace("Encoded CSK HMAC digest has an invalid format.");
            CAMCryptoException cce = new CAMCryptoException("Encoded CSK HMAC digest has an invalid format.");
            cskTraceLogger.logExit(cce);
            throw cce;
        }
        this.cskDigest = new byte[cskDigestLength];
        System.arraycopy(encodedDigest, 4, this.cskDigest, 0, this.cskDigest.length);
        this.hmacDigest = new byte[encodedDigest.length - cskDigestLength - 4];
        System.arraycopy(encodedDigest, 4 + cskDigestLength, this.hmacDigest, 0, this.hmacDigest.length);
        cskTraceLogger.trace("hmacDigest = " + new String(this.hmacDigest));
        cskTraceLogger.logExit(true);
    }
}

