/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.utilities;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.casync.CaCacheMessaging;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.PriorityUrlList;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class CAMHttpClient {
    public String testSendingFreshnessRequest() throws CAMCryptoException {
        StringBuffer output = new StringBuffer();
        CAMFactory cf = new CAMFactory("CAMHttpClient");
        Configuration config = Configuration.getInstance();
        PriorityUrlList urls = config.getPeers();
        Iterator<URL> thisUrl = urls.getIterator();
        int n = 0;
        while (thisUrl.hasNext()) {
            URL url = thisUrl.next();
            output.append("\n\n" + ++n + ": Connecting to " + url.toString() + "... ");
            String req = this.createFreshnessRqquest();
            PostMethod post = new PostMethod();
            post.setRequestBody(req);
            post.setPath(url.getFile());
            post.setRequestHeader("Content-type", "text/xml");
            post.setRequestHeader("SOAPAction", "\"http://www.ibm.com/xmlns/prod/cognos/contentManagerService/201505/\"");
            int resultCode = 0;
            String response = null;
            HttpClient hc = cf.createHttpClient(url);
            try {
                resultCode = hc.executeMethod((HttpMethod)post);
            }
            catch (ConnectException e) {
                output.append("\n" + e.toString() + "\n");
            }
            catch (HttpException e) {
                output.append("\n" + e.toString() + "\n");
            }
            catch (IOException e) {
                output.append("\n" + e.toString() + "\n");
            }
            if (resultCode < 200 || resultCode > 299) {
                output.append("Connection failed ! HTTP return code = " + resultCode + "\n");
                continue;
            }
            output.append("Connected OK. HTTP return code = " + resultCode + "\n");
            try {
                response = CAMCryptoUtilities.getResponseString(post);
                post.releaseConnection();
            }
            catch (ConnectException e) {
                output.append("CAMCryptoUtilities.getResponseString failed. Exception = " + e.toString() + "\n");
            }
            catch (IOException e) {
                output.append("CAMCryptoUtilities.getResponseString failed. Exception = " + e.toString() + "\n");
            }
            try {
                output.append(n + ": Sending message to " + url.toString() + "... ");
                CaCacheMessaging caCacheMessaging = new CaCacheMessaging();
                byte[] payload = caCacheMessaging.removeBibusWrapper(response.getBytes());
                Integer freshness = caCacheMessaging.parseFreshnessResponse(payload);
                output.append("Return value (freshness) for testing is " + freshness.toString() + "\n");
            }
            catch (Exception e) {
                output.append(e.toString());
            }
            output.append("\n");
        }
        output.append("\n");
        return output.toString();
    }

    private String createFreshnessRqquest() throws CAMCryptoException {
        CaCacheMessaging caCacheMessaging = new CaCacheMessaging();
        byte[] baFresh = caCacheMessaging.createFreshnessRequest();
        String xmlMsg = caCacheMessaging.createBibusWrapper(baFresh);
        return xmlMsg;
    }
}

