/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.jni;

import com.cognos.accman.jcam.crypto.jni.CryptoByteBuffer;
import com.cognos.accman.jcam.crypto.jni.JNIFileLock;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class JNISystemProperties {
    private static final String[] ALGORITHMS = new String[]{"DES", "DES-CBC", "3DES", "RC2", "RC4", "RC2-40", "RC4-40", "AES", "AES128", "AES256"};
    private static final Set<String> ALGORITHM_SET = new HashSet<String>(Arrays.asList(ALGORITHMS));
    private static boolean osViolation = false;
    private static boolean osViolationChecked = false;
    private static byte[] byteBuffer = null;
    private static byte[] byteBuffer2 = null;
    private static byte[] byteBuffer3 = null;
    private static Object byteBuffer2Lock = new Object();
    private static Object byteBuffer3Lock = new Object();

    public byte[] getByteBuffer() {
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteBuffer2(int param) {
        if (byteBuffer2 == null) {
            Object object = byteBuffer2Lock;
            synchronized (object) {
                if (byteBuffer2 != null) {
                    return byteBuffer2;
                }
                CryptoByteBuffer cbb = CryptoByteBuffer.getInstance();
                byteBuffer2 = cbb.getByteBuffer2(param);
            }
        }
        return (byte[])byteBuffer2.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteBuffer3(int param) {
        if (byteBuffer3 == null) {
            Object object = byteBuffer3Lock;
            synchronized (object) {
                if (byteBuffer3 != null) {
                    return byteBuffer3;
                }
                CryptoByteBuffer cbb = CryptoByteBuffer.getInstance();
                byteBuffer3 = cbb.getByteBuffer3(param);
            }
        }
        return (byte[])byteBuffer3.clone();
    }

    public static JNIFileLock lockFile(String file, StringBuffer sb) {
        JNIFileLock lock = null;
        try {
            lock = new JNIFileLock(file);
            JNISystemProperties._lockFile(file, lock, sb);
        }
        catch (FileNotFoundException e) {
            sb.append(e.getLocalizedMessage());
        }
        return lock;
    }

    public static void _lockFile(String file, JNIFileLock lock, StringBuffer error) {
        try {
            lock.lock();
        }
        catch (IOException e) {
            error.append(e.getLocalizedMessage());
        }
    }

    public static void unlockFile(JNIFileLock lock) {
        try {
            lock.unlock();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean checkAlgorithm(String algorithm, StringBuffer error) {
        boolean algOK = ALGORITHM_SET.contains(algorithm);
        if (error != null) {
            if (algOK) {
                error.append("JNISystemProperties.checkAlgorithm: acceptable algorithm.");
            } else {
                error.append("JNISystemProperties.checkAlgorithm: not an acceptable algorithm.");
            }
        }
        return algOK;
    }

    public static int getRSAKeyLength() {
        return 2048;
    }

    public static int getDSAKeyLength() {
        return 2048;
    }

    public static int getFIPSKeyLength() {
        return 2048;
    }

    public static boolean CheckFIPSOsViolation() {
        if (!osViolationChecked) {
            String os = System.getProperty("os.name").toLowerCase();
            String osArch = System.getProperty("os.arch").toLowerCase();
            if (os.contains("linux") && osArch.contains("ppc")) {
                osViolation = true;
            } else if (os.contains("os/390")) {
                osViolation = true;
            }
            osViolationChecked = true;
        }
        return osViolation;
    }
}

