/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.external;

import com.netflix.config.AbstractPollingScheduler;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class FixedDelayPollingSchedulerOnYourExecutor
extends AbstractPollingScheduler {
    private final ScheduledExecutorService executor;
    private final int initialDelayMillis;
    private final int delayMillis;
    ScheduledFuture<?> scheduledFuture;

    public FixedDelayPollingSchedulerOnYourExecutor(ScheduledExecutorService executorService, int initialDelayMillis, int delayMillis, boolean ignoreDeletesFromSource) {
        super(ignoreDeletesFromSource);
        this.executor = executorService;
        this.initialDelayMillis = initialDelayMillis;
        this.delayMillis = delayMillis;
    }

    protected synchronized void schedule(Runnable runnable) {
        if (this.scheduledFuture == null) {
            this.scheduledFuture = this.executor.scheduleWithFixedDelay(runnable, this.initialDelayMillis, this.delayMillis, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void stop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
    }

    public static ScheduledExecutorService makePollingExecutorService(final String threadName) {
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread t = new Thread(runnable, threadName);
                t.setDaemon(true);
                return t;
            }
        });
    }
}

