/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema.handlers;

import com.ibm.bi.soap.schema.DeserializationContext;
import com.ibm.bi.soap.schema.SOAPWriter;
import com.ibm.bi.soap.schema.SerializationContext;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.schema.TypeHandler;
import com.ibm.bi.soap.xml.XmlStreamUtils;
import javax.xml.stream.XMLStreamException;

public class StringHandler
implements TypeHandler {
    @Override
    public Object deserialize(DeserializationContext dc, Type type) throws XMLStreamException {
        if (dc.isXsiNil()) {
            XmlStreamUtils.skipElement(dc.reader);
            return dc.json.createNull();
        }
        return dc.json.createString(dc.getElementText());
    }

    @Override
    public void serialize(SerializationContext sc, String tag, Type type, Object value) {
        ((SOAPWriter)sc.writer.element(tag)).type(type);
        if (sc.json.isNull(value)) {
            sc.writer.xsiNil();
        } else {
            String text = sc.json.toString(value);
            if (text.length() >= sc.cdataThreshold) {
                sc.writer.cdata(text);
            } else {
                sc.writer.text(text);
            }
        }
        sc.writer.end();
    }
}

