/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.services;

import com.ibm.bi.soap.schema.DeserializationContext;
import com.ibm.bi.soap.schema.SoapFaultHandler;
import com.ibm.bi.soap.services.SoapException;
import com.ibm.bi.soap.xml.XMLUtils;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class SoapQueryFaultHanlder
implements SoapFaultHandler {
    @Override
    public void parseFault(DeserializationContext dc) throws XMLStreamException, SoapException {
        String tagContent = null;
        StringBuilder textBuilder = new StringBuilder();
        Map detail = dc.json.createObject();
        List exceptionMessages = dc.json.createArray();
        String faultCode = null;
        String elementName = null;
        while (dc.reader.hasNext()) {
            int event = dc.reader.next();
            switch (event) {
                case 4: {
                    tagContent = dc.reader.getText();
                    textBuilder.append(tagContent);
                    break;
                }
                case 2: {
                    elementName = dc.reader.getLocalName();
                    if ("faultcode".equals(elementName)) {
                        faultCode = XMLUtils.collapseWhiteSpace(textBuilder.toString());
                        detail.put(dc.json.createString("faultcode"), faultCode);
                    } else if ("faultstring".equals(elementName)) {
                        detail.put(dc.json.createString("faultstring"), XMLUtils.collapseWhiteSpace(textBuilder.toString()));
                    } else if ("messageString".equals(elementName)) {
                        if (exceptionMessages != null) {
                            exceptionMessages.add(XMLUtils.collapseWhiteSpace(textBuilder.toString()));
                        }
                    } else if ("detail".equals(elementName)) {
                        String msg;
                        if (textBuilder.length() > 0 && !(msg = XMLUtils.collapseWhiteSpace(textBuilder.toString())).isEmpty() && exceptionMessages != null) {
                            exceptionMessages.add(msg);
                        }
                        detail.put(dc.json.createString("messages"), exceptionMessages);
                    }
                    textBuilder.setLength(0);
                    break;
                }
                case 1: {
                    if ("faultDataSource".equals(dc.reader.getLocalName()) && dc.reader.getAttributeCount() == 1 && "value".equals(dc.reader.getAttributeLocalName(0))) {
                        detail.put(dc.json.createString("dataSourceName"), dc.reader.getAttributeValue(0));
                    } else if ("name".equals(dc.reader.getLocalName()) && "faultConnection".equals(elementName) && dc.reader.getAttributeCount() == 1 && "value".equals(dc.reader.getAttributeLocalName(0))) {
                        detail.put(dc.json.createString("dataSourceConnectionName"), dc.reader.getAttributeValue(0));
                    }
                    elementName = dc.reader.getLocalName();
                    break;
                }
            }
        }
        if (faultCode != null && !"".equals(faultCode)) {
            throw new SoapException(400, faultCode, detail);
        }
    }
}

