/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.common.utils;

import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.Filter;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemNormalizationGroupType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemNormalizationType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.MoserObject;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.PropertyType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import java.util.ArrayList;
import java.util.List;

public class MoserObjectUtils {
    protected static final String ID_SEPARATOR = ".";

    private MoserObjectUtils() {
    }

    public static void propertyOverrideForPropertyType(MoserObject objType, PropertyType item) {
        if (objType != null && objType instanceof ObjectType) {
            ObjectType obj = (ObjectType)objType;
            Module module = MoserObject.getModuleObject(objType);
            if (module != null && module.isOverrideMode() && item.getName() != null) {
                MoserObjectUtils.setPropertyOverride(obj.getFeatureName(87) + ID_SEPARATOR + item.getName(), obj);
            }
        }
    }

    public static void propertyOverrideForLocalRef(MoserObject itemHierarchy) {
        if (itemHierarchy != null && itemHierarchy instanceof ObjectType) {
            ObjectType obj = (ObjectType)itemHierarchy;
            Module module = MoserObject.getModuleObject(itemHierarchy);
            if (module != null && module.isOverrideMode()) {
                MoserObjectUtils.setPropertyOverride(obj.getFeatureName(73), obj);
            }
        }
    }

    public static void propertyOverrideForTaxonomyType(MoserObject taxonomyObj) {
        ObjectType objType = MoserObjectUtils.getObjectTypeParent(taxonomyObj);
        if (objType != null) {
            MoserObject.updatePropertyOverride(objType, objType, 246, false);
        }
    }

    public static void propertyOverrideForFacetType(MoserObject facetObj) {
        ObjectType objType = MoserObjectUtils.getObjectTypeParent(facetObj);
        if (objType != null) {
            MoserObject.updatePropertyOverride(objType, objType, 249, false);
        }
    }

    private static ObjectType getObjectTypeParent(MoserObject obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ObjectType) {
            return (ObjectType)obj;
        }
        return MoserObjectUtils.getObjectTypeParent(obj.getParent());
    }

    private static void setPropertyOverride(String featureName, ObjectType obj) {
        List overrideList = MoserObjectUtils.getList(obj.basicGetPropertyOverride());
        for (String override : overrideList) {
            if (!override.equals(featureName) && !"NEW".equals(override)) continue;
            return;
        }
        obj.addPropertyOverride(featureName);
    }

    public static List<QueryItem> getQueryItems(List<ItemType> items) {
        ArrayList<QueryItem> qItems = new ArrayList<QueryItem>();
        if (items == null) {
            return qItems;
        }
        for (ItemType item : items) {
            if (item.getQueryItem() != null) {
                qItems.add(item.getQueryItem());
                continue;
            }
            if (item.getFolder() == null) continue;
            qItems.addAll(MoserObjectUtils.getQueryItems(item.getFolder().basicGetItem()));
        }
        return qItems;
    }

    public static List<QueryItem> getQueryItems(QuerySubject qs) {
        return MoserObjectUtils.getQueryItems(qs.basicGetItem());
    }

    public static List<Filter> getFilters(List<ItemType> items) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (items == null) {
            return filters;
        }
        for (ItemType item : items) {
            if (item.getFilter() != null) {
                filters.add(item.getFilter());
                continue;
            }
            if (item.getFolder() == null) continue;
            filters.addAll(MoserObjectUtils.getFilters(item.getFolder().basicGetItem()));
        }
        return filters;
    }

    public static List<Filter> getFilters(QuerySubject qs) {
        return MoserObjectUtils.getFilters(qs.basicGetItem());
    }

    public static List<FolderType> getFolderTypes(Module module) {
        ArrayList<FolderType> qFolders = new ArrayList<FolderType>();
        List<FolderType> folders = module.basicGetMetadataTreeView();
        if (folders != null) {
            for (FolderType folder : folders) {
                qFolders.add(folder);
                MoserObjectUtils.collectFolderTypes(qFolders, folder.basicGetFolderItem());
            }
        }
        return qFolders;
    }

    private static void collectFolderTypes(List<FolderType> qFolders, List<FolderItemType> folderItems) {
        if (folderItems != null) {
            for (FolderItemType folderItem : folderItems) {
                FolderType folder = folderItem.getFolder();
                if (folder == null) continue;
                qFolders.add(folder);
                MoserObjectUtils.collectFolderTypes(qFolders, folder.basicGetFolderItem());
            }
        }
    }

    public static List<ObjectType> getItems(ObjectType obj) {
        ArrayList<ObjectType> qItems = new ArrayList<ObjectType>();
        String objectType = obj.getObjectType();
        if ("QuerySubject".equals(objectType)) {
            MoserObjectUtils.collectItems(qItems, ((QuerySubject)obj).basicGetItem());
        } else if ("QueryItem".equals(objectType)) {
            MoserObjectUtils.collectItems(qItems, ((QueryItem)obj).basicGetItem());
        } else if ("Folder".equals(objectType)) {
            MoserObjectUtils.collectItems(qItems, ((ItemType.Folder)obj).basicGetItem());
        }
        return qItems;
    }

    private static void collectItems(List<ObjectType> allItems, List<ItemType> items) {
        if (items != null) {
            for (ItemType item : items) {
                if (item.getFilter() != null) {
                    allItems.add(item.getFilter());
                    continue;
                }
                if (item.getFolder() != null) {
                    ItemType.Folder f = item.getFolder();
                    allItems.add(f);
                    MoserObjectUtils.collectItems(allItems, f.basicGetItem());
                    continue;
                }
                if (item.getItemHierarchy() != null) {
                    allItems.add(item.getItemHierarchy());
                    continue;
                }
                if (item.getNamedSet() != null) {
                    allItems.add(item.getNamedSet());
                    continue;
                }
                if (item.getCalculation() != null) {
                    Calculation calc = item.getCalculation();
                    allItems.add(calc);
                    MoserObjectUtils.collectItems(allItems, calc.basicGetItem());
                    continue;
                }
                if (item.getQueryItem() == null) continue;
                QueryItem qi = item.getQueryItem();
                allItems.add(qi);
                MoserObjectUtils.collectItems(allItems, qi.basicGetItem());
            }
        }
    }

    private static void removeQueryItem(List<ItemType> items, QueryItem qi) {
        if (items == null) {
            return;
        }
        String id = qi.getIdentifier();
        for (int i = items.size() - 1; i >= 0; --i) {
            ItemType item = items.get(i);
            QueryItem qitem = item.getQueryItem();
            if (qitem != null && qitem.getIdentifier().equals(id)) {
                items.remove(i);
                break;
            }
            if (item.getFolder() == null) continue;
            MoserObjectUtils.removeQueryItem(item.getFolder().basicGetItem(), qi);
            List<ItemType> folderItems = item.getFolder().basicGetItem();
            if (folderItems != null && !folderItems.isEmpty()) continue;
            items.remove(i);
        }
    }

    public static void removeQueryItem(QuerySubject qs, QueryItem qi) {
        MoserObjectUtils.removeQueryItem(qs.basicGetItem(), qi);
    }

    public static List<QueryItem> getMeasures(List<ItemType> items) {
        ArrayList<QueryItem> qItems = new ArrayList<QueryItem>();
        if (items == null) {
            return qItems;
        }
        for (ItemType item : items) {
            if (item.getQueryItem() != null) {
                qItems.add(item.getQueryItem());
                qItems.addAll(MoserObjectUtils.getMeasures(item.getQueryItem().basicGetItem()));
                continue;
            }
            if (item.getFolder() == null) continue;
            qItems.addAll(MoserObjectUtils.getMeasures(item.getFolder().basicGetItem()));
        }
        return qItems;
    }

    public static List<QueryItem> getMeasures(QuerySubject qs) {
        return MoserObjectUtils.getMeasures(qs.basicGetItem());
    }

    public static List<ItemNormalizationGroupType> getItemNormalizationGroups(QuerySubject qs) {
        ArrayList<ItemNormalizationGroupType> rt = new ArrayList<ItemNormalizationGroupType>();
        ItemNormalizationType itemNormalization = qs.getItemNormalization();
        if (itemNormalization == null) {
            return rt;
        }
        List<ItemNormalizationGroupType> grps = itemNormalization.basicGetItemNormalizationGroup();
        if (grps != null) {
            rt.addAll(grps);
        }
        return rt;
    }

    public static List getList(List lst) {
        ArrayList rt = lst;
        if (rt == null) {
            rt = new ArrayList();
        }
        return rt;
    }
}

