/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.datatype;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.ibm.smarts.model.datatype.BaseDataType;
import com.ibm.smarts.model.datatype.BooleanType;
import com.ibm.smarts.model.datatype.ByteType;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.datatype.DateType;
import com.ibm.smarts.model.datatype.DecimalType;
import com.ibm.smarts.model.datatype.DoubleType;
import com.ibm.smarts.model.datatype.FloatType;
import com.ibm.smarts.model.datatype.IntegerType;
import com.ibm.smarts.model.datatype.LongType;
import com.ibm.smarts.model.datatype.ShortType;
import com.ibm.smarts.model.datatype.StringType;
import com.ibm.smarts.model.datatype.TimeType;
import com.ibm.smarts.model.datatype.TimestampType;
import com.ibm.smarts.model.datatype.UnknownType;
import java.io.IOException;

public class DataTypeDeserializer
extends StdDeserializer<DataType> {
    private static final long serialVersionUID = 7355608328179005432L;

    DataTypeDeserializer() {
        super(DataType.class);
    }

    protected DataTypeDeserializer(Class<DataType> vc) {
        super(vc);
    }

    public DataType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String type = node.get("type").asText();
        BaseDataType dataType = BaseDataType.UNKNOWN;
        try {
            dataType = BaseDataType.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        switch (dataType) {
            case BOOLEAN: {
                return new BooleanType();
            }
            case BYTE: {
                return new ByteType();
            }
            case SHORT: {
                return new ShortType();
            }
            case INTEGER: {
                return new IntegerType();
            }
            case LONG: {
                return new LongType();
            }
            case FLOAT: {
                return new FloatType();
            }
            case DOUBLE: {
                return new DoubleType();
            }
            case DECIMAL: {
                int precision = 0;
                int scale = 0;
                if (node.get("precision") != null) {
                    precision = node.get("precision").numberValue().intValue();
                }
                if (node.get("scale") != null) {
                    scale = node.get("scale").numberValue().intValue();
                }
                return new DecimalType(precision, scale);
            }
            case DATE: {
                return new DateType();
            }
            case TIMESTAMP: {
                return new TimestampType();
            }
            case TIME: {
                return new TimeType();
            }
            case STRING: {
                JsonNode maxLengthNode = node.get("maxLength");
                if (maxLengthNode != null) {
                    int maxLength = maxLengthNode.numberValue().intValue();
                    return new StringType(maxLength);
                }
                return new StringType();
            }
        }
        return new UnknownType();
    }

    public DataType deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(jp, ctxt);
    }
}

