/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.schema.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.util.JAXBHelper;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class BivariateStatisticDeserializer
extends StdDeserializer<BivariateStatistics> {
    private static final long serialVersionUID = -6747734684045772114L;
    public static final String FIELD_NAME_COLUMN_1 = "column1";
    public static final String FIELD_NAME_COLUMN_2 = "column2";

    protected BivariateStatisticDeserializer() {
        super(BivariateStatistics.class);
    }

    protected BivariateStatisticDeserializer(Class<?> vc) {
        super(vc);
    }

    public BivariateStatistics deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        BivariateStatistics bivariateStatistics = new BivariateStatistics();
        bivariateStatistics.setColumn1(this.validateValue(node, FIELD_NAME_COLUMN_1));
        bivariateStatistics.setColumn2(this.validateValue(node, FIELD_NAME_COLUMN_2));
        JsonNode fieldNode = node.get("statistics");
        if (fieldNode != null && !fieldNode.isNull()) {
            List<Statistic> statistics = bivariateStatistics.getStatistics();
            for (JsonNode statNode : fieldNode) {
                Statistic statistic = JAXBHelper.parseJson(Statistic.class, statNode);
                statistics.add(statistic);
            }
        }
        return bivariateStatistics;
    }

    private String validateValue(JsonNode node, String field) {
        String column = this.getJSONValue(node, field);
        if (StringUtils.isBlank((CharSequence)column)) {
            String errorMsg = String.format("Failed to deserialize BivariateStatistic's %s for value %s", field, column);
            throw new IllegalArgumentException(errorMsg);
        }
        return column;
    }

    private String getJSONValue(JsonNode node, String field) {
        JsonNode fieldNode = node.get(field);
        if (fieldNode != null && !fieldNode.isNull()) {
            return fieldNode.asText();
        }
        return null;
    }
}

