/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.common.utils;

import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MoserConnectionSpec {
    String connection;
    String signon;
    private static final String CONNECTIONS_STR = "connections";
    private static final String DATASOURCE_STR = "datasource";
    private static final String CONNECTION_STR = "connection";
    private static final String SIGNON_STR = "signon";
    public static final String VENDOR_STR = "vendor";
    private String datasource;
    protected Map<String, String> vendor;

    public MoserConnectionSpec(String ds, String connectionSpec) {
        block6: {
            this.connection = null;
            this.signon = null;
            this.datasource = null;
            this.vendor = null;
            this.datasource = ds;
            if (connectionSpec != null) {
                try {
                    JSONObject jConnSpec = JSONObject.parse((String)connectionSpec);
                    if (jConnSpec == null) break block6;
                    JSONArray connections = (JSONArray)jConnSpec.get((Object)CONNECTIONS_STR);
                    if (connections != null) {
                        for (Object o : connections) {
                            JSONObject aConnection = (JSONObject)o;
                            if (ds != null && !ds.equals(aConnection.get((Object)DATASOURCE_STR))) continue;
                            this.connection = (String)aConnection.get((Object)CONNECTION_STR);
                            this.signon = (String)aConnection.get((Object)SIGNON_STR);
                            this.datasource = (String)aConnection.get((Object)DATASOURCE_STR);
                            break;
                        }
                    } else {
                        this.connection = (String)jConnSpec.get((Object)CONNECTION_STR);
                        this.signon = (String)jConnSpec.get((Object)SIGNON_STR);
                        this.datasource = (String)jConnSpec.get((Object)DATASOURCE_STR);
                    }
                    JSONObject jVendor = (JSONObject)jConnSpec.get((Object)VENDOR_STR);
                    this.addVendor(jVendor);
                }
                catch (IOException e) {
                    throw new MoserException(e);
                }
            }
        }
    }

    public MoserConnectionSpec(String ds, String c, String s) {
        this.connection = null;
        this.signon = null;
        this.datasource = null;
        this.vendor = null;
        this.datasource = ds;
        this.connection = c;
        this.signon = s;
    }

    public String getConnection() {
        return this.connection;
    }

    public String getSignon() {
        return this.signon;
    }

    public JSONObject toJSON() {
        JSONObject ret = new JSONObject();
        if (this.connection == null && this.signon == null) {
            return ret;
        }
        JSONArray connections = new JSONArray();
        ret.put((Object)CONNECTIONS_STR, (Object)connections);
        JSONObject aConnection = new JSONObject();
        connections.add((Object)aConnection);
        if (this.datasource != null) {
            aConnection.put((Object)DATASOURCE_STR, (Object)this.datasource);
        }
        if (this.connection != null) {
            aConnection.put((Object)CONNECTION_STR, (Object)this.connection);
        }
        if (this.signon != null) {
            aConnection.put((Object)SIGNON_STR, (Object)this.signon);
        }
        if (this.vendor != null) {
            JSONObject ven = new JSONObject();
            for (Map.Entry<String, String> entry : this.vendor.entrySet()) {
                ven.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            ret.put((Object)VENDOR_STR, (Object)ven);
        }
        return ret;
    }

    public String toString() {
        return this.toJSON().toString();
    }

    public Map<String, String> getVendor() {
        return this.vendor;
    }

    public void addVendor(JSONObject ven) {
        if (ven == null) {
            return;
        }
        this.vendor = new TreeMap<String, String>();
        Set keys = ven.keySet();
        for (String k : keys) {
            Object value = ven.get((Object)k);
            if (!(value instanceof String)) continue;
            this.vendor.put(k, (String)value);
        }
    }
}

