/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema.handlers;

import com.ibm.bi.json.JsonFactory;
import com.ibm.bi.soap.schema.DeserializationContext;
import com.ibm.bi.soap.schema.SerializationContext;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.schema.handlers.StructHandler;
import java.util.Arrays;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class PropertyMappingHandler
extends StructHandler {
    private String[] from;
    private String[] to;

    public PropertyMappingHandler(String from, String to) {
        this.from = new String[]{from};
        this.to = new String[]{to};
    }

    public PropertyMappingHandler(String[] from, String[] to) {
        this.from = Arrays.copyOf(from, from.length);
        this.to = Arrays.copyOf(to, to.length);
    }

    @Override
    public Object deserialize(DeserializationContext dc, Type type) throws XMLStreamException {
        JsonFactory json = dc.json;
        Object obj = super.deserialize(dc, type);
        if (json.isNull(obj)) {
            return obj;
        }
        this.updateNames(json, (Map)obj, this.from, this.to);
        return obj;
    }

    @Override
    public void serialize(SerializationContext sc, String tag, Type type, Object value) {
        JsonFactory json = sc.json;
        if (value instanceof Map) {
            this.updateNames(json, (Map)value, this.to, this.from);
        }
        super.serialize(sc, tag, type, value);
    }

    private void updateNames(JsonFactory json, Map obj, String[] from, String[] to) {
        for (int i = 0; i < from.length; ++i) {
            Object fromName = json.createString(from[i]);
            if (!obj.containsKey(fromName)) continue;
            Object value = obj.remove(fromName);
            obj.put(json.createString(to[i]), value);
        }
    }
}

