/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.services;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonFactory;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.soap.schema.DeserializationContext;
import com.ibm.bi.soap.schema.Method;
import com.ibm.bi.soap.schema.SoapDeserializer;
import com.ibm.bi.soap.schema.SoapFaultHandler;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.schema.TypeLibrary;
import com.ibm.bi.soap.services.BiBus;
import com.ibm.bi.soap.services.ServiceLoader;
import com.ibm.bi.soap.services.SoapContext;
import com.ibm.bi.soap.services.SoapException;
import com.ibm.bi.soap.services.SoapService;
import com.ibm.bi.soap.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;

public class ReportService
extends SoapService
implements SoapFaultHandler {
    public static final String BASE64 = "base64";
    public static final String MIME = "MIME";
    public static final String MIMECompressed = "MIMECompressed";
    private byte[] soapResponse;
    private JsonArray extraOptions = null;
    private static Method QUERY;
    private static Method RUN;
    private static Method VALIDATE;
    private static Method RUNREPORTSPECIFICATION;
    private static Method RUNMETADATASPECIFICATION;
    private static Method GETCONFIGURATION;
    private static Method WAIT;
    private static Method CANCEL;
    private static Method RELEASE;
    private static Method GETPARAMETERS;
    private static Method NORMALIZESPECIFICATION;
    private static Method ADD;

    public ReportService(BiBus bus) {
        super(bus);
    }

    static void init(TypeLibrary typeLib) throws XMLStreamException, IOException {
        HashMap<String, Method> methods;
        ServiceLoader serviceLoader = new ServiceLoader();
        try (InputStream is = ReportService.class.getResourceAsStream("reportService.xml");){
            methods = serviceLoader.load(typeLib, is);
            IOUtils.closeQuietly((InputStream)is);
            QUERY = methods.get("query");
            RUN = methods.get("run");
            VALIDATE = methods.get("validate");
            RUNMETADATASPECIFICATION = methods.get("runSpecification");
            GETCONFIGURATION = methods.get("getConfiguration");
            WAIT = methods.get("wait");
            CANCEL = methods.get("cancel");
            RELEASE = methods.get("release");
            GETPARAMETERS = methods.get("getParameters");
            NORMALIZESPECIFICATION = methods.get("normalizeSpecification");
            ADD = methods.get("add");
        }
        is = ReportService.class.getResourceAsStream("reportService_1.xml");
        var3_3 = null;
        try {
            methods = serviceLoader.load(typeLib, is);
            IOUtils.closeQuietly((InputStream)is);
            RUNREPORTSPECIFICATION = methods.get("runSpecification");
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var3_3 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
    }

    public void addOption(JsonObject option) {
        if (option != null) {
            if (this.extraOptions == null) {
                JsonFactory json = this.bus.getJsonFactory();
                this.extraOptions = (JsonArray)json.createArray();
            }
            this.extraOptions.add((Object)option);
        }
    }

    public void clearOptions() {
        this.extraOptions = null;
    }

    private void setOptions(Map request, List options) {
        JsonFactory json = this.bus.getJsonFactory();
        if (this.extraOptions != null) {
            for (Object option : this.extraOptions) {
                options.add(option);
            }
        }
        request.put(json.createString("options"), options);
    }

    public Map query(String searchPath, long nPrimaryWaitThreshold, long nSecondaryWaitThreshold) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map queryRequest = json.createObject();
        queryRequest.put(json.createString("objectPath"), json.createString(searchPath));
        List options = json.createArray();
        Map primaryWaitThreshold = json.createObject();
        primaryWaitThreshold.put(json.createString("type"), json.createString("asynchOptionInt"));
        primaryWaitThreshold.put(json.createString("name"), json.createString("primaryWaitThreshold"));
        primaryWaitThreshold.put(json.createString("value"), json.createLong(nPrimaryWaitThreshold));
        options.add(primaryWaitThreshold);
        Map secondaryWaitThreshold = json.createObject();
        secondaryWaitThreshold.put(json.createString("type"), json.createString("asynchOptionInt"));
        secondaryWaitThreshold.put(json.createString("name"), json.createString("secondaryWaitThreshold"));
        secondaryWaitThreshold.put(json.createString("value"), json.createLong(nSecondaryWaitThreshold));
        options.add(secondaryWaitThreshold);
        Map propertiesOption = json.createObject();
        propertiesOption.put(json.createString("type"), json.createString("contentManagerQueryOptionPropEnumArray"));
        propertiesOption.put(json.createString("name"), json.createString("properties"));
        List propList = json.createArray();
        propList.add(json.createString("defaultName"));
        propList.add(json.createString("searchPath"));
        propList.add(json.createString("specification"));
        propList.add(json.createString("metadataModel"));
        propList.add(json.createString("permissions"));
        propList.add(json.createString("searchPath"));
        propList.add(json.createString("module"));
        propList.add(json.createString("paths"));
        propList.add(json.createString("modificationTime"));
        propList.add(json.createString("runInAdvancedViewer"));
        propertiesOption.put(json.createString("value"), propList);
        options.add(propertiesOption);
        Map optionRefProp = json.createObject();
        optionRefProp.put(json.createString("type"), json.createString("contentManagerQueryOptionRefPropArray"));
        optionRefProp.put(json.createString("name"), json.createString("referenceProperties"));
        Map refPropItem = json.createObject();
        refPropItem.put(json.createString("type"), json.createString("refProp"));
        refPropItem.put(json.createString("refPropName"), json.createString("parent"));
        List properties = json.createArray();
        properties.add(json.createString("objectClass"));
        properties.add(json.createString("searchPath"));
        refPropItem.put(json.createString("properties"), properties);
        List refPropList = json.createArray();
        refPropList.add(refPropItem);
        optionRefProp.put(json.createString("value"), refPropList);
        options.add(optionRefProp);
        Map rsQueryOptionSpecFormat = json.createObject();
        rsQueryOptionSpecFormat.put(json.createString("type"), json.createString("reportServiceQueryOptionSpecificationFormat"));
        rsQueryOptionSpecFormat.put(json.createString("name"), json.createString("specificationFormat"));
        rsQueryOptionSpecFormat.put(json.createString("value"), json.createString("report"));
        options.add(rsQueryOptionSpecFormat);
        Map upgradeOption = json.createObject();
        upgradeOption.put(json.createString("type"), json.createString("reportServiceQueryOptionBoolean"));
        upgradeOption.put(json.createString("name"), json.createString("upgrade"));
        upgradeOption.put(json.createString("value"), json.createBoolean(Boolean.TRUE.booleanValue()));
        options.add(upgradeOption);
        Map runOption = json.createObject();
        runOption.put(json.createString("type"), json.createString("runOptionBoolean"));
        runOption.put(json.createString("name"), json.createString("prompt"));
        runOption.put(json.createString("value"), json.createBoolean(false));
        options.add(runOption);
        this.setOptions(queryRequest, options);
        return (Map)this.invoke(Function.query.getMethod(), queryRequest);
    }

    public Map getParameters(String searchPath, Long nPrimaryWaitThreshold, Long nSecondaryWaitThreshold, Boolean layoutParameters) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map getParametersRequest = json.createObject();
        getParametersRequest.put(json.createString("objectPath"), json.createString(searchPath));
        List parameterValues = json.createArray();
        getParametersRequest.put(json.createString("parameterValues"), parameterValues);
        List options = json.createArray();
        if (nPrimaryWaitThreshold != null) {
            Map primaryWaitThreshold = json.createObject();
            primaryWaitThreshold.put(json.createString("type"), json.createString("asynchOptionInt"));
            primaryWaitThreshold.put(json.createString("name"), json.createString("primaryWaitThreshold"));
            primaryWaitThreshold.put(json.createString("value"), json.createLong(nPrimaryWaitThreshold.longValue()));
            options.add(primaryWaitThreshold);
        }
        if (nSecondaryWaitThreshold != null) {
            Map secondaryWaitThreshold = json.createObject();
            secondaryWaitThreshold.put(json.createString("type"), json.createString("asynchOptionInt"));
            secondaryWaitThreshold.put(json.createString("name"), json.createString("secondaryWaitThreshold"));
            secondaryWaitThreshold.put(json.createString("value"), json.createLong(nSecondaryWaitThreshold.longValue()));
            options.add(secondaryWaitThreshold);
        }
        if (layoutParameters != null) {
            Map layoutParametersOption = json.createObject();
            layoutParametersOption.put(json.createString("type"), json.createString("runOptionBoolean"));
            layoutParametersOption.put(json.createString("name"), json.createString("layoutParameters"));
            layoutParametersOption.put(json.createString("value"), json.createBoolean(layoutParameters.booleanValue()));
            options.add(layoutParametersOption);
        }
        this.setOptions(getParametersRequest, options);
        return (Map)this.invoke(Function.getParameters.getMethod(), getParametersRequest);
    }

    public Map run(String searchPath) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map runRequest = json.createObject();
        runRequest.put(json.createString("objectPath"), json.createString(searchPath));
        List parameterValues = json.createArray();
        runRequest.put(json.createString("parameterValues"), parameterValues);
        List options = json.createArray();
        this.setOptions(runRequest, options);
        return (Map)this.invoke(Function.run.getMethod(), runRequest);
    }

    public Map validate(String searchPath) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map validateRequest = json.createObject();
        validateRequest.put(json.createString("objectPath"), json.createString(searchPath));
        List parameterValues = json.createArray();
        validateRequest.put(json.createString("parameterValues"), parameterValues);
        List options = json.createArray();
        this.setOptions(validateRequest, options);
        return (Map)this.invoke(Function.validate.getMethod(), validateRequest);
    }

    public Map normalizeSpecification(String objectPath, String specification) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map normalizeSpecificationRequest = json.createObject();
        if (objectPath != null && !objectPath.isEmpty()) {
            normalizeSpecificationRequest.put(json.createString("objectPath"), json.createString(objectPath));
        }
        if (specification != null && !specification.isEmpty()) {
            Map specificationMap = json.createObject();
            specificationMap.put(json.createString("type"), json.createString("reportServiceReportSpecification"));
            specificationMap.put(json.createString("value"), json.createString(specification));
            normalizeSpecificationRequest.put(json.createString("specification"), specificationMap);
        }
        return (Map)this.invoke(Function.normalizeSpecification.getMethod(), normalizeSpecificationRequest);
    }

    public Map add(String parentPath, JsonObject authoredReport, JsonObject options) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map addRequest = json.createObject();
        if (parentPath != null && !parentPath.isEmpty()) {
            addRequest.put(json.createString("parentPath"), json.createString(parentPath));
            addRequest.put(json.createString("object"), authoredReport);
            addRequest.put(json.createString("options"), options);
        }
        return (Map)this.invoke(Function.add.getMethod(), addRequest);
    }

    public Map runReportSpecification(StringBuilder reportSpec, long nPrimaryWaitThreshold, long nSecondaryWaitThreshold, String encoding) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map runReportSpecRequest = json.createObject();
        Map specification = json.createObject();
        specification.put(json.createString("type"), json.createString("reportServiceReportSpecification"));
        specification.put(json.createString("value"), json.createString(reportSpec.toString()));
        runReportSpecRequest.put(json.createString("specification"), specification);
        List parameterValues = json.createArray();
        runReportSpecRequest.put(json.createString("parameterValues"), parameterValues);
        List options = json.createArray();
        Map primaryWaitThreshold = json.createObject();
        primaryWaitThreshold.put(json.createString("type"), json.createString("asynchOptionInt"));
        primaryWaitThreshold.put(json.createString("name"), json.createString("primaryWaitThreshold"));
        primaryWaitThreshold.put(json.createString("value"), json.createLong(nPrimaryWaitThreshold));
        options.add(primaryWaitThreshold);
        Map secondaryWaitThreshold = json.createObject();
        secondaryWaitThreshold.put(json.createString("type"), json.createString("asynchOptionInt"));
        secondaryWaitThreshold.put(json.createString("name"), json.createString("secondaryWaitThreshold"));
        secondaryWaitThreshold.put(json.createString("value"), json.createLong(nSecondaryWaitThreshold));
        options.add(secondaryWaitThreshold);
        Map outputFormat = json.createObject();
        outputFormat.put(json.createString("type"), json.createString("runOptionStringArray"));
        outputFormat.put(json.createString("name"), json.createString("outputFormat"));
        List formatList = json.createArray();
        formatList.add(json.createString("XHTML"));
        outputFormat.put(json.createString("value"), formatList);
        options.add(outputFormat);
        Map xslURL = json.createObject();
        xslURL.put(json.createString("type"), json.createString("runOptionAnyURI"));
        xslURL.put(json.createString("name"), json.createString("xslURL"));
        xslURL.put(json.createString("value"), json.createString("null.xsl"));
        options.add(xslURL);
        Map promptFormat = json.createObject();
        promptFormat.put(json.createString("type"), json.createString("runOptionString"));
        promptFormat.put(json.createString("name"), json.createString("promptFormat"));
        promptFormat.put(json.createString("value"), json.createString("HTMLFragment"));
        options.add(promptFormat);
        Map prompt = json.createObject();
        prompt.put(json.createString("type"), json.createString("runOptionBoolean"));
        prompt.put(json.createString("name"), json.createString("prompt"));
        prompt.put(json.createString("value"), json.createBoolean(Boolean.FALSE.booleanValue()));
        options.add(prompt);
        Map outputLocation = json.createObject();
        outputLocation.put(json.createString("type"), json.createString("runOptionAnyURI"));
        outputLocation.put(json.createString("name"), json.createString("outputLocation"));
        outputLocation.put(json.createString("value"), json.createString("http://developer.cognos.com/ceba/constants/temporaryObjectLocationEnum#serverFileSystem"));
        options.add(outputLocation);
        this.setOptions(runReportSpecRequest, options);
        return (Map)this.invoke(Function.runReportSpecification.getMethod(), runReportSpecRequest);
    }

    public Map runMetadataSpecification(StringBuilder metadataSpec, long nPrimaryWaitThreshold, long nSecondaryWaitThreshold, String encoding) throws Exception {
        return this.runMetadataSpecification(metadataSpec, nPrimaryWaitThreshold, nSecondaryWaitThreshold, encoding, null);
    }

    public Map runMetadataSpecification(StringBuilder metadataSpec, long nPrimaryWaitThreshold, long nSecondaryWaitThreshold, String encoding, JsonArray parameters) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map runMetadataSpecRequest = json.createObject();
        Map specification = json.createObject();
        specification.put(json.createString("type"), json.createString("reportServiceMetadataSpecification"));
        specification.put(json.createString("value"), json.createString(metadataSpec.toString()));
        runMetadataSpecRequest.put(json.createString("specification"), specification);
        Object parameterValues = parameters != null ? parameters : json.createArray();
        runMetadataSpecRequest.put(json.createString("parameterValues"), parameterValues);
        List options = json.createArray();
        Map primaryWaitThreshold = json.createObject();
        primaryWaitThreshold.put(json.createString("type"), json.createString("asynchOptionInt"));
        primaryWaitThreshold.put(json.createString("name"), json.createString("primaryWaitThreshold"));
        primaryWaitThreshold.put(json.createString("value"), json.createLong(nPrimaryWaitThreshold));
        options.add(primaryWaitThreshold);
        Map secondaryWaitThreshold = json.createObject();
        secondaryWaitThreshold.put(json.createString("type"), json.createString("asynchOptionInt"));
        secondaryWaitThreshold.put(json.createString("name"), json.createString("secondaryWaitThreshold"));
        secondaryWaitThreshold.put(json.createString("value"), json.createLong(nSecondaryWaitThreshold));
        options.add(secondaryWaitThreshold);
        Map prompt = json.createObject();
        prompt.put(json.createString("type"), json.createString("runOptionBoolean"));
        prompt.put(json.createString("name"), json.createString("prompt"));
        prompt.put(json.createString("value"), json.createBoolean(Boolean.FALSE.booleanValue()));
        options.add(prompt);
        Map promptFormat = json.createObject();
        promptFormat.put(json.createString("type"), json.createString("runOptionString"));
        promptFormat.put(json.createString("name"), json.createString("promptFormat"));
        promptFormat.put(json.createString("value"), json.createString("XHTMLFRGMT"));
        options.add(promptFormat);
        Map interactive = json.createObject();
        interactive.put(json.createString("type"), json.createString("genericOptionBoolean"));
        interactive.put(json.createString("name"), json.createString("http://developer.cognos.com/ceba/constants/runOptionEnum#interactive"));
        interactive.put(json.createString("value"), json.createBoolean(Boolean.TRUE.booleanValue()));
        options.add(interactive);
        Map xslURL = json.createObject();
        xslURL.put(json.createString("type"), json.createString("runOptionAnyURI"));
        xslURL.put(json.createString("name"), json.createString("xslURL"));
        xslURL.put(json.createString("value"), json.createString("V5html_viewer.xsl"));
        options.add(xslURL);
        Map returnOutputWhenAvailable = json.createObject();
        returnOutputWhenAvailable.put(json.createString("type"), json.createString("runOptionBoolean"));
        returnOutputWhenAvailable.put(json.createString("name"), json.createString("returnOutputWhenAvailable"));
        returnOutputWhenAvailable.put(json.createString("value"), json.createBoolean(Boolean.TRUE.booleanValue()));
        options.add(returnOutputWhenAvailable);
        Map asyncOptionEncoding = json.createObject();
        asyncOptionEncoding.put(json.createString("type"), json.createString("asynchOptionEncoding"));
        asyncOptionEncoding.put(json.createString("name"), json.createString("attachmentEncoding"));
        asyncOptionEncoding.put(json.createString("value"), json.createString(encoding));
        options.add(asyncOptionEncoding);
        this.setOptions(runMetadataSpecRequest, options);
        return (Map)this.invoke(Function.runMetadataSpecification.getMethod(), runMetadataSpecRequest);
    }

    public Map getConfiguration(String[] keys, String productLocale, String contentLocale) throws Exception {
        SoapContext soapContext = this.bus.getContext();
        soapContext.addUserPreferenceVars("productLocale", productLocale);
        soapContext.addUserPreferenceVars("contentLocale", contentLocale);
        JsonFactory json = this.bus.getJsonFactory();
        Map configurationRequest = json.createObject();
        List properties = json.createArray();
        for (int i = 0; i < keys.length; ++i) {
            properties.add(json.createString(keys[i]));
        }
        configurationRequest.put(json.createString("properties"), properties);
        return (Map)this.invoke(Function.getConfiguration.getMethod(), configurationRequest);
    }

    public Map wait(JsonObject primaryRequest, long nPrimaryWaitThreshold, long nSecondaryWaitThreshold) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map waitRequest = json.createObject();
        waitRequest.put(json.createString("conversation"), primaryRequest);
        List parameterValues = json.createArray();
        waitRequest.put(json.createString("parameterValues"), parameterValues);
        List options = json.createArray();
        Map primaryWaitThreshold = json.createObject();
        primaryWaitThreshold.put(json.createString("type"), json.createString("asynchOptionInt"));
        primaryWaitThreshold.put(json.createString("name"), json.createString("primaryWaitThreshold"));
        primaryWaitThreshold.put(json.createString("value"), json.createLong(nPrimaryWaitThreshold));
        options.add(primaryWaitThreshold);
        Map secondaryWaitThreshold = json.createObject();
        secondaryWaitThreshold.put(json.createString("type"), json.createString("asynchOptionInt"));
        secondaryWaitThreshold.put(json.createString("name"), json.createString("secondaryWaitThreshold"));
        secondaryWaitThreshold.put(json.createString("value"), json.createLong(nSecondaryWaitThreshold));
        options.add(secondaryWaitThreshold);
        this.setOptions(waitRequest, options);
        return (Map)this.invoke(Function.wait.getMethod(), waitRequest);
    }

    public Map cancel(JsonObject primaryRequest) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map cancelRequest = json.createObject();
        cancelRequest.put(json.createString("conversation"), primaryRequest);
        return (Map)this.invoke(Function.cancel.getMethod(), cancelRequest);
    }

    public Map release(JsonObject primaryRequest) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map releaseRequest = json.createObject();
        releaseRequest.put(json.createString("conversation"), primaryRequest);
        return (Map)this.invoke(Function.release.getMethod(), releaseRequest);
    }

    @Override
    public void parseFault(DeserializationContext dc) throws XMLStreamException, SoapException {
        String tagContent = null;
        StringBuilder textBuilder = new StringBuilder();
        Map detail = dc.json.createObject();
        List exceptionMessages = dc.json.createArray();
        String faultCode = null;
        while (dc.reader.hasNext()) {
            int event = dc.reader.next();
            switch (event) {
                case 4: {
                    tagContent = dc.reader.getText();
                    textBuilder.append(tagContent);
                    break;
                }
                case 2: {
                    if ("faultcode".equals(dc.reader.getLocalName())) {
                        detail.put(dc.json.createString("faultcode"), XMLUtils.collapseWhiteSpace(textBuilder.toString()));
                    } else if ("faultstring".equals(dc.reader.getLocalName())) {
                        detail.put(dc.json.createString("faultstring"), XMLUtils.collapseWhiteSpace(textBuilder.toString()));
                    } else if ("severity".equals(dc.reader.getLocalName())) {
                        detail.put(dc.json.createString("severity"), XMLUtils.collapseWhiteSpace(textBuilder.toString()));
                    } else if ("errorCode".equals(dc.reader.getLocalName())) {
                        faultCode = XMLUtils.collapseWhiteSpace(textBuilder.toString());
                        detail.put(dc.json.createString("errorCode"), faultCode);
                    } else if ("messageString".equals(dc.reader.getLocalName())) {
                        if (exceptionMessages != null) {
                            exceptionMessages.add(XMLUtils.collapseWhiteSpace(textBuilder.toString()));
                        }
                    } else if ("exception".equals(dc.reader.getLocalName())) {
                        detail.put(dc.json.createString("messages"), exceptionMessages);
                    }
                    textBuilder.setLength(0);
                    break;
                }
            }
        }
        if (faultCode != null && !"".equals(faultCode)) {
            throw new SoapException(400, faultCode, detail);
        }
    }

    @Override
    protected SoapFaultHandler getSoapFaultHandler() {
        return this;
    }

    public JsonObject parseResponse(InputStream responseStream, Function function) throws XMLStreamException, SoapException {
        return this.parseResponseStream(responseStream, function.getMethod());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject parseResponseStream(InputStream in, Method m) throws XMLStreamException, SoapException {
        try {
            this.soapResponse = IOUtils.toByteArray((InputStream)in);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(this.soapResponse);){
            TypeLibrary typeLib = BiBus.getTypeLibrary();
            Type biBusHeader = typeLib.getSchemaByName("bus").getType("biBusHeader");
            SoapDeserializer d = new SoapDeserializer(typeLib, this.bus.getJsonFactory(), this.bus.getBaseUrl());
            JsonObject result = (JsonObject)d.parseSOAPResponse(is, biBusHeader, m, this.getSoapFaultHandler());
            this.bus.getContext().updateFromResponse(result.get(this.bus.getJsonFactory().createString("header")));
            Map header = (Map)result.get(this.bus.getJsonFactory().createString("header"));
            JsonObject resultHeader = new JsonObject();
            if (header.containsKey("hdrSession")) {
                resultHeader.put("hdrSession", header.get("hdrSession"));
            }
            if (header.containsKey("tracking")) {
                resultHeader.put("tracking", header.get("tracking"));
            }
            if (header.containsKey("routing")) {
                resultHeader.put("routing", header.get("routing"));
            }
            result.put("header", (Object)resultHeader);
            JsonObject jsonObject = result;
            return jsonObject;
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public byte[] getSoapResponse() {
        return this.soapResponse;
    }

    @Override
    protected Object parseResponse(CloseableHttpResponse response, Method m) throws XMLStreamException, SoapException {
        try {
            return this.parseResponseStream(this.getResponseStream(response), m);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    private InputStream getResponseStream(CloseableHttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            throw new IOException("no entity");
        }
        return entity.getContent();
    }

    static /* synthetic */ Method access$000() {
        return QUERY;
    }

    static /* synthetic */ Method access$100() {
        return RUN;
    }

    static /* synthetic */ Method access$200() {
        return VALIDATE;
    }

    static /* synthetic */ Method access$300() {
        return RUNREPORTSPECIFICATION;
    }

    static /* synthetic */ Method access$400() {
        return RUNMETADATASPECIFICATION;
    }

    static /* synthetic */ Method access$500() {
        return GETCONFIGURATION;
    }

    static /* synthetic */ Method access$600() {
        return WAIT;
    }

    static /* synthetic */ Method access$700() {
        return CANCEL;
    }

    static /* synthetic */ Method access$800() {
        return RELEASE;
    }

    static /* synthetic */ Method access$900() {
        return GETPARAMETERS;
    }

    static /* synthetic */ Method access$1000() {
        return NORMALIZESPECIFICATION;
    }

    static /* synthetic */ Method access$1100() {
        return ADD;
    }

    public static enum Function {
        query(ReportService.access$000()),
        run(ReportService.access$100()),
        validate(ReportService.access$200()),
        runReportSpecification(ReportService.access$300()),
        runMetadataSpecification(ReportService.access$400()),
        getConfiguration(ReportService.access$500()),
        wait(ReportService.access$600()),
        cancel(ReportService.access$700()),
        release(ReportService.access$800()),
        getParameters(ReportService.access$900()),
        normalizeSpecification(ReportService.access$1000()),
        add(ReportService.access$1100());

        private Method m;

        private Function(Method m) {
            this.m = m;
        }

        public Method getMethod() {
            return this.m;
        }
    }
}

