/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.services;

import com.ibm.bi.soap.schema.Method;
import com.ibm.bi.soap.schema.SoapDeserializer;
import com.ibm.bi.soap.schema.SoapFaultHandler;
import com.ibm.bi.soap.schema.SoapSerializer;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.schema.TypeLibrary;
import com.ibm.bi.soap.services.BiBus;
import com.ibm.bi.soap.services.MimeAttachment;
import com.ibm.bi.soap.services.SoapContext;
import com.ibm.bi.soap.services.SoapException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;

public abstract class SoapService {
    private int DEFAULT_REQUEST_TIMEOUT = 30000;
    protected BiBus bus;

    public SoapService(BiBus bus) {
        this.bus = bus;
    }

    protected abstract SoapFaultHandler getSoapFaultHandler();

    protected Object invoke(Method m, Map params) throws Exception {
        return this.invoke(m, params, this.DEFAULT_REQUEST_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invoke(Method m, Map params, int requestTimeout) throws Exception {
        Object object;
        DataStream dataStream = new DataStream();
        List<MimeAttachment> attachments = this.serializeRequest(m, params, dataStream);
        CloseableHttpResponse response = null;
        try {
            SoapContext ctx = this.bus.getContext();
            InputStream is = null;
            if (ctx.isTrusted()) {
                byte[] buf = ctx.setMessageTrust(dataStream.getBytes());
                is = new ByteArrayInputStream(buf);
            } else {
                is = dataStream.getInputStream();
            }
            response = this.bus.getTransport().sendRequest(m.getSoapAction(), ctx, is, attachments, requestTimeout);
            object = this.parseResponse(response, m);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((OutputStream)dataStream);
            IOUtils.closeQuietly(response);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)dataStream);
        IOUtils.closeQuietly((Closeable)response);
        return object;
    }

    private List<MimeAttachment> serializeRequest(Method m, Map params, DataStream dataStream) {
        Object header = this.bus.getContext().getSoapHeader();
        TypeLibrary typeLib = BiBus.getTypeLibrary();
        Type biBusHeader = typeLib.getSchemaByName("bus").getType("biBusHeader");
        SoapSerializer serializer = new SoapSerializer(typeLib, this.bus.getJsonFactory());
        List<MimeAttachment> result = serializer.writeSoapRequest(dataStream, header, biBusHeader, m, params);
        this.bus.getContext().resetSoapHeader();
        return result;
    }

    protected Object parseResponse(CloseableHttpResponse response, Method m) throws XMLStreamException, SoapException, IOException {
        TypeLibrary typeLib = BiBus.getTypeLibrary();
        Type biBusHeader = typeLib.getSchemaByName("bus").getType("biBusHeader");
        SoapDeserializer d = new SoapDeserializer(typeLib, this.bus.getJsonFactory(), this.bus.getBaseUrl());
        Map result = d.parseSOAPResponse(response.getEntity().getContent(), biBusHeader, m, this.getSoapFaultHandler());
        this.bus.getContext().updateFromResponse(result.get(this.bus.getJsonFactory().createString("header")));
        return result.get(this.bus.getJsonFactory().createString("body"));
    }

    private static class DataStream
    extends ByteArrayOutputStream {
        private DataStream() {
        }

        InputStream getInputStream() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }

        byte[] getBytes() {
            if (this.buf.length == this.count) {
                return this.buf;
            }
            return Arrays.copyOf(this.buf, this.count);
        }
    }
}

