/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.services;

import com.ibm.bi.soap.schema.DeserializationContext;
import com.ibm.bi.soap.schema.SoapFaultHandler;
import com.ibm.bi.soap.services.SoapException;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class TestConnectionFaultHandler
implements SoapFaultHandler {
    private static final String[] ARRAYS = new String[]{"dataSource", "connection", "signon"};

    @Override
    public void parseFault(DeserializationContext dc) throws SoapException, XMLStreamException {
        String errorCode = null;
        Map detail = dc.json.createObject();
        while (dc.reader.nextTag() == 1) {
            String tag = dc.reader.getLocalName();
            if ("faultcode".equals(tag)) {
                errorCode = dc.reader.getElementText();
                continue;
            }
            if ("faultstring".equals(tag)) {
                detail.put(dc.json.createString("message"), dc.json.createString(dc.reader.getElementText()));
                continue;
            }
            if ("faultSubcode".equals(tag)) {
                detail.put(dc.json.createString("subcode"), dc.json.createString(dc.reader.getElementText()));
                continue;
            }
            if ("faultSubstring".equals(tag)) {
                detail.put(dc.json.createString("reason"), dc.json.createString(dc.reader.getElementText()));
                continue;
            }
            if ("detail".equals(tag)) {
                List<Object> messages = this.parseDetailElement(dc);
                detail.put(dc.json.createString("messages"), messages);
                continue;
            }
            Object value = this.parseElement(dc);
            this.addProperty(dc, detail, tag, value);
        }
        if (errorCode != null) {
            throw new SoapException(400, errorCode, detail);
        }
    }

    private List<Object> parseDetailElement(DeserializationContext dc) throws SoapException, XMLStreamException {
        List<Object> result;
        Object value = this.parseElement(dc);
        if (value instanceof String) {
            result = dc.json.createArray();
            if (!((String)value).isEmpty()) {
                result.add(value);
            }
        } else {
            result = this.extractMessages(dc, value);
        }
        return result;
    }

    private List<Object> extractMessages(DeserializationContext dc, Object details) {
        List array = dc.json.createArray();
        try {
            Object exception = ((Map)details).get(dc.json.createString("exception"));
            Object message = ((Map)exception).get(dc.json.createString("message"));
            if (message instanceof List) {
                for (Object msg : (List)message) {
                    this.addMessageString(dc, array, msg);
                }
            } else {
                this.addMessageString(dc, array, message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return array;
    }

    private void addMessageString(DeserializationContext dc, List array, Object message) {
        if (!(message instanceof Map)) {
            return;
        }
        Object value = ((Map)message).get(dc.json.createString("messageString"));
        if (value != null) {
            array.add(value);
        }
    }

    private boolean isArray(String tag) {
        for (String s : ARRAYS) {
            if (!s.equals(tag)) continue;
            return true;
        }
        return false;
    }

    private Object parseElement(DeserializationContext dc) throws SoapException, XMLStreamException {
        StringBuilder buf = new StringBuilder();
        Object result = null;
        if (dc.reader.getAttributeCount() != 0) {
            result = dc.reader.getAttributeValue(0);
        }
        boolean isText = true;
        block5: while (true) {
            switch (dc.reader.next()) {
                case 4: 
                case 12: {
                    if (!isText) continue block5;
                    buf.append(dc.reader.getText());
                    continue block5;
                }
                case 1: {
                    isText = false;
                    if (!(result instanceof Map)) {
                        result = dc.json.createObject();
                    }
                    String tagName = dc.reader.getLocalName();
                    Object value = this.parseElement(dc);
                    this.addProperty(dc, (Map)result, tagName, value);
                    continue block5;
                }
                case 2: {
                    if (result == null) {
                        result = buf.toString();
                    }
                    return result;
                }
            }
        }
    }

    private void addProperty(DeserializationContext dc, Map parent, String tag, Object value) {
        Object propName = dc.json.createString(tag);
        Object old = parent.get(propName);
        if (old instanceof List) {
            ((List)old).add(value);
        } else if (old == null && !this.isArray(tag)) {
            parent.put(propName, value);
        } else {
            List array = dc.json.createArray();
            if (old != null) {
                array.add(old);
            }
            array.add(value);
            parent.put(propName, array);
        }
    }
}

