/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search;

import com.ibm.bi.rest.RESTClientFactory;
import com.ibm.bi.search.async.SearchExecutor;
import com.ibm.bi.search.async.StorageCleaner;
import com.ibm.bi.search.extract.BackgroundTask;
import com.ibm.bi.search.handlers.collections.CollectionsController;
import com.ibm.bi.search.handlers.collections.CollectionsHandler;
import com.ibm.bi.search.handlers.healthcheck.HealthHandler;
import com.ibm.bi.search.handlers.indices.IndicesHandler;
import com.ibm.bi.search.handlers.search.SearchHandler;
import com.ibm.bi.search.handlers.select.SelectHandler;
import com.ibm.bi.search.handlers.suggest.SuggestHandler;
import com.ibm.bi.search.indexing.solr.EmbeddedSolrHandler;
import com.ibm.bi.search.util.SearchConfig;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchService
extends Application {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String CURRENT_VERSION = "2.32.endorR7";
    private static String version = "2.32.endorR7";
    public static final int SUCCESS_CODE = 200;
    public static final int CREATED_CODE = 201;
    public static final int BAD_REQUEST = 400;
    public static final int FORBIDDEN_CODE = 403;
    public static final int UNAUTHORIZED_CODE = 401;
    public static final int NOT_FOUND_CODE = 404;
    public static final int CONFLICT_CODE = 409;
    public static final int INTERNAL_ERROR_CODE = 500;
    private static State state = State.CREATED;
    private static CollectionsController collectionsController = new CollectionsController();
    private static StorageCleaner storageCleaner = new StorageCleaner();
    private static BackgroundTask extractionTask = null;

    public static String getVersion() {
        return version;
    }

    public static void setVersion(String version) {
        SearchService.version = version;
    }

    public static State getState() {
        return state;
    }

    private static void setState(State state) {
        SearchService.state = state;
    }

    public Set<Class<?>> getClasses() {
        HashSet classes = new HashSet();
        classes.add(SearchHandler.class);
        classes.add(IndicesHandler.class);
        classes.add(SuggestHandler.class);
        classes.add(SelectHandler.class);
        classes.add(CollectionsHandler.class);
        classes.add(HealthHandler.class);
        return classes;
    }

    public static void initialize() {
        LOG.info("Initializing Search Service.");
        try {
            SearchService.tryInitialize();
        }
        catch (Exception e) {
            LOG.error("Initialization Failed.", (Throwable)e);
            SearchService.setState(State.FAILED_TO_INITIALIZE);
        }
    }

    private static void tryInitialize() {
        SearchExecutor.initialize();
        storageCleaner.deleteNow(SearchConfig.getTempDirectory());
        collectionsController.initialize();
        extractionTask = new BackgroundTask();
        extractionTask.start();
        RESTClientFactory.getInstance().startup();
        SearchService.setState(State.INITIALIZED);
        LOG.info("Search Service started. Search Version: {}", (Object)SearchService.getVersion());
    }

    public static void terminate() {
        if (extractionTask != null) {
            extractionTask.stop();
        }
        RESTClientFactory.getInstance().shutdown();
        EmbeddedSolrHandler.shutdown();
        SearchExecutor.shutdown();
        SearchService.setState(State.TERMINATED);
        LOG.info("Search Service Stopped.");
    }

    protected static void setCollectionsControllerForTesting(CollectionsController controller) {
        collectionsController = controller;
    }

    public static CollectionsController getCollectionsController() {
        return collectionsController;
    }

    public static boolean isAvailable() {
        return EmbeddedSolrHandler.isAvailable();
    }

    public static enum State {
        CREATED,
        INITIALIZED,
        TERMINATED,
        FAILED_TO_INITIALIZE;

    }
}

