/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.search.SearchService;
import com.ibm.bi.search.util.BIConfig;
import com.ibm.bi.search.util.PollingBiConfig;
import java.lang.invoke.MethodHandles;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchServiceContextListener
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static BIConfig biConfig = new PollingBiConfig();

    public void contextInitialized(ServletContextEvent event) {
        LOG.info("Waiting for BI configuration to be ready.");
        try {
            biConfig.callWhenReady(this::initializeSearchService);
        }
        catch (Exception e) {
            LOG.error("Context initialization has failed.", (Throwable)e);
        }
    }

    private void initializeSearchService(ConfigurationPropertyFactory configFactory) {
        SearchService.initialize();
    }

    public void contextDestroyed(ServletContextEvent event) {
        SearchService.terminate();
    }

    public static void setBiConfigForTesting(BIConfig testConfig) {
        biConfig = testConfig;
    }

    public static void reset() {
        biConfig = new PollingBiConfig();
    }
}

