/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.async;

import com.ibm.bi.search.async.Task;
import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.util.SearchConfig;
import java.lang.invoke.MethodHandles;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Map<Task.Type, ExecutorService> EXECUTORS = new EnumMap<Task.Type, ExecutorService>(Task.Type.class);
    private static long terminationTimeoutInMillis;

    public static void initialize() {
        SearchExecutor.createDynamicThreadPool(Task.Type.READ_ONLY);
        SearchExecutor.createDynamicThreadPool(Task.Type.READ_WRITE);
        SearchExecutor.createFixedThreadPool(Task.Type.LONG_DURATION, SearchConfig.getLongDurationThreadPoolSize());
        terminationTimeoutInMillis = SearchConfig.getTerminationTimeoutInMillis();
    }

    private static void createDynamicThreadPool(Task.Type taskType) {
        EXECUTORS.put(taskType, Executors.newCachedThreadPool());
    }

    private static void createFixedThreadPool(Task.Type taskType, int threadPoolSize) {
        EXECUTORS.put(taskType, Executors.newFixedThreadPool(threadPoolSize));
    }

    public static void shutdown() {
        EXECUTORS.forEach((type, executor) -> SearchExecutor.shutdown(executor));
    }

    private static void shutdown(ExecutorService executor) {
        executor.shutdown();
        try {
            if (!executor.awaitTermination(terminationTimeoutInMillis, TimeUnit.MILLISECONDS)) {
                LOG.warn("Timeout while waiting for active tasks to finish. Shutting down now.");
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for active tasks to finish. Shutting down now.");
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public Response invoke(Task task) {
        long startTime = System.nanoTime();
        Future<Response> future = this.submit(task);
        try {
            Response response = future.get();
            return response;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw SearchException.wrap((Exception)e, "Request was interrupted.", new Object[0]);
        }
        catch (ExecutionException e) {
            throw SearchException.wrap((Exception)e, "Failed to handle request.", new Object[0]);
        }
        finally {
            this.logElapsedTime(task, startTime);
        }
    }

    public Future<Response> submit(Task task) {
        ExecutorService executor = EXECUTORS.get((Object)task.getType());
        return executor.submit(task);
    }

    private void logElapsedTime(Task task, long startTime) {
        if (LOG.isTraceEnabled()) {
            long elapsed = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
            LOG.trace("{} executed in {} millis.", (Object)task.getClass().getSimpleName(), (Object)elapsed);
        }
    }
}

