/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.async;

import com.ibm.bi.search.async.SearchExecutor;
import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.indexing.solr.policies.DeleteFolderTask;
import com.ibm.bi.search.util.SearchConfig;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageCleaner {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SearchExecutor executor;
    private final String tempFolder;

    public StorageCleaner() {
        this(new SearchExecutor(), SearchConfig.getTempDirectory());
    }

    protected StorageCleaner(SearchExecutor executor, String tempFolder) {
        this.executor = executor;
        this.tempFolder = tempFolder;
    }

    public void deleteNow(String folderName) {
        File folder = new File(folderName);
        if (folder.exists()) {
            try {
                LOG.debug("Deleting folder: {}", (Object)folder);
                FileUtils.deleteDirectory((File)folder);
            }
            catch (Exception e) {
                LOG.error("Failed to delete temp folder: " + folder, (Throwable)e);
            }
        }
    }

    public void deleteLater(String folderName) {
        File folder = new File(folderName);
        if (folder.exists()) {
            Path tempTarget = Paths.get(this.tempFolder, "to.be.deleted." + System.currentTimeMillis());
            this.moveFolder(folder.toPath(), tempTarget);
            this.startDeleteFolderTask(tempTarget);
        }
    }

    private void moveFolder(Path source, Path target) {
        LOG.debug("Moving [{}] to a temporary folder: [{}]", (Object)source, (Object)target);
        try {
            FileUtils.forceMkdirParent((File)target.toFile());
            Files.move(source, target, new CopyOption[0]);
        }
        catch (Exception e) {
            throw SearchException.wrap(e, "Failed to move [" + source + "] to [" + target + "].", new Object[0]);
        }
    }

    private void startDeleteFolderTask(Path folder) {
        LOG.debug("Starting a separate thread to delete folder [{}].", (Object)folder);
        try {
            this.executor.submit(new DeleteFolderTask(folder));
        }
        catch (Exception e) {
            throw SearchException.wrap(e, "Failed to delete folder [" + folder + "].", new Object[0]);
        }
    }
}

