/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.background;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.constants.IndexNames;
import com.ibm.bi.search.extract.SavedOutput;
import com.ibm.bi.search.handlers.common.QueryResult;
import com.ibm.bi.search.indexing.solr.SolrHandlerFactory;
import com.ibm.bi.search.indexing.solr.SolrQueryFactory;
import com.ibm.bi.search.util.Ancestors;
import com.ibm.bi.search.util.SearchUtils;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateOutputController {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String CM = IndexNames.CM.toString();
    private final SolrHandlerFactory solrFactory;
    private final SolrQueryFactory queryFactory;

    public UpdateOutputController() {
        this(new SolrHandlerFactory(), new SolrQueryFactory());
    }

    protected UpdateOutputController(SolrHandlerFactory solrFactory, SolrQueryFactory queryFactory) {
        this.solrFactory = solrFactory;
        this.queryFactory = queryFactory;
    }

    public void processDocuments() {
        JsonArray notProcessedDocuments = this.getDocumentsWithNotProcessedContent();
        for (Object o : notProcessedDocuments) {
            LOG.trace("Processing {} content objects.", (Object)notProcessedDocuments.size());
            JsonObject document = (JsonObject)o;
            String objectContent = UpdateOutputController.processObjectContent(document.getString(FieldNames.ID.toString()));
            this.updateOutputDocument(document, objectContent);
            this.updateParentReportDocument(this.getParentReport(document), objectContent);
        }
    }

    private JsonArray getDocumentsWithNotProcessedContent() {
        QueryResult result = this.solrFactory.createSolrHandler().query(CM, this.queryFactory.createQueryForNotProcessedContent());
        return result.toJSON().getArray("results");
    }

    private static String processObjectContent(String documentId) {
        SavedOutput content = new SavedOutput(documentId);
        return content.analyzeOutputDataFile();
    }

    private void updateOutputDocument(JsonObject document, String content) {
        UpdateOutputController.removeUnnecessaryFieldsFromDocument(document);
        document.set(FieldNames.CONTENT.toString(), (Object)content);
        this.solrFactory.createSolrHandler().updateDocument(CM, document);
    }

    private JsonObject getParentReport(JsonObject childDocument) {
        Map<String, JsonObject> ancestorDocuments = this.getAncestorDocuments(childDocument);
        for (JsonObject ancestor : new ArrayList<JsonObject>(ancestorDocuments.values())) {
            if (!SearchUtils.isParentTypeOfOutput(ancestor.getString(FieldNames.TYPE.toString()))) continue;
            return ancestor;
        }
        return null;
    }

    private Map<String, JsonObject> getAncestorDocuments(JsonObject document) {
        String ancestorPath = Ancestors.getAncestorPath(document);
        List<String> ancestorIds = Ancestors.getAncestorIds(ancestorPath);
        QueryResult result = this.solrFactory.createSolrHandler().query(CM, this.queryFactory.createQueryByIds(ancestorIds));
        return Ancestors.sortByPath(ancestorPath, result.toJSON().getArray("results"));
    }

    private void updateParentReportDocument(JsonObject document, String content) {
        if (document == null) {
            LOG.warn("Parent report object was not found when updating not processed content.");
            return;
        }
        UpdateOutputController.removeUnnecessaryFieldsFromDocument(document);
        document.set(FieldNames.COMBINED_CONTENT.toString(), (Object)content);
        this.solrFactory.createSolrHandler().updateDocument(CM, document);
    }

    private static void removeUnnecessaryFieldsFromDocument(JsonObject document) {
        document.remove((Object)FieldNames.INTERNAL_VERSION.toString());
        document.remove((Object)FieldNames.SCORE.toString());
    }
}

