/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class Identity {
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static final String DEFAULT_LOCALE_NAME = DEFAULT_LOCALE.toLanguageTag();
    private static final String SYSTEM_ADMIN = "CAMID(\"::System Administrators\")";
    private static final String TENANT_ADMIN = "CAMID(\"::Tenant Administrators\")";
    private static final String PUBLIC_TENANT_ID = "";
    private boolean isSystemAdmin;
    private boolean isTenantAdmin;
    private boolean isViewLimited;
    private String storeID;
    private List<String> camIDs;
    private List<String> tenantIDs;
    private String productLocale;
    private String contentLocale;

    public Identity(List<String> camIDs, String tenantID, List<String> readTenantIDs) {
        this.camIDs = camIDs == null ? Collections.emptyList() : camIDs;
        this.lookForSystemAndTenantAdmins();
        this.isViewLimited = Identity.isViewLimited(readTenantIDs);
        this.tenantIDs = this.buildTenantIDs(tenantID, readTenantIDs);
    }

    private void lookForSystemAndTenantAdmins() {
        for (String camID : this.camIDs) {
            if (camID.contains(SYSTEM_ADMIN)) {
                this.isSystemAdmin = true;
            }
            if (!camID.contains(TENANT_ADMIN)) continue;
            this.isTenantAdmin = true;
        }
    }

    private static boolean isViewLimited(List<String> readTenantIDs) {
        return CollectionUtils.isNotEmpty(readTenantIDs);
    }

    private List<String> buildTenantIDs(String tenantID, List<String> readTenantIDs) {
        ArrayList<String> ids = new ArrayList<String>();
        if (this.isViewLimited) {
            ids.addAll(readTenantIDs);
        } else {
            ids.add(tenantID);
        }
        if (!ids.contains(PUBLIC_TENANT_ID)) {
            ids.add(PUBLIC_TENANT_ID);
        }
        return ids;
    }

    public List<String> getCAMIds() {
        return this.camIDs;
    }

    public void setUserStoreID(String value) {
        this.storeID = StringUtils.lowerCase((String)value);
    }

    public String getUserStoreID() {
        return this.storeID;
    }

    public boolean isSystemAdmin() {
        return this.isSystemAdmin;
    }

    public boolean isTenantAdmin() {
        return this.isTenantAdmin;
    }

    public boolean isViewLimited() {
        return this.isViewLimited;
    }

    public boolean isUnauthenticated() {
        return false;
    }

    public List<String> getTenantIDs() {
        return this.tenantIDs;
    }

    public void setProductLocale(String productLocale) {
        this.productLocale = productLocale;
    }

    public String getProductLocale() {
        return this.productLocale;
    }

    public void setContentLocale(String contentLocale) {
        this.contentLocale = contentLocale;
    }

    public String getContentLocale() {
        return this.contentLocale;
    }

    public void setUpLocales(String prodLocale, String contLocale) {
        if (this.getProductLocale() == null) {
            this.setProductLocale(prodLocale != null ? prodLocale : DEFAULT_LOCALE_NAME);
        }
        if (this.getContentLocale() == null) {
            this.setContentLocale(contLocale != null ? contLocale : DEFAULT_LOCALE_NAME);
        }
    }

    public static Locale getProductLocale(Identity identity) {
        return Locale.forLanguageTag(Identity.getProductLocaleAsString(identity));
    }

    public static String getProductLocaleAsString(Identity identity) {
        String locale = identity != null ? identity.getProductLocale() : null;
        return locale != null ? locale : DEFAULT_LOCALE_NAME;
    }

    public static Locale getContentLocale(Identity identity) {
        return Locale.forLanguageTag(Identity.getContentLocaleAsString(identity));
    }

    public static String getContentLocaleAsString(Identity identity) {
        String locale = identity != null ? identity.getContentLocale() : null;
        return locale != null ? locale : DEFAULT_LOCALE_NAME;
    }
}

