/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.common;

import com.ibm.bi.search.util.SearchConfig;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;

public class RestLogger {
    private static final String RX_SEARCH_REQUEST = "RX: {} {}";
    private static final String RX_SEARCH_REQUEST_WITH_PAYLOAD = "RX: {} {} + Payload: {}";
    private static final String TX_SEARCH_RESPONSE = "TX: {}";
    private static final String TX_SEARCH_RESPONSE_WITH_PAYLOAD = "TX: {} + Payload: {}";
    private static final String TX_SOLR_REQUEST = "TX SOLR: ";
    private static final String RX_SOLR_RESPONSE = "RX SOLR: {}";
    private static final String RX_SOLR_RESPONSE_ELAPSED = "RX SOLR ({} ms): {}";
    private static final String RX_SOLR_EXCEPTION = "RX SOLR ERROR: {}, Caused by: {}";
    private static final String DOT_DOT_DOT = "...";
    private static final String MORE = " more characters";
    private final Logger logger;

    public RestLogger(Logger logger) {
        this.logger = logger;
    }

    public void logSearchRequest(HttpServletRequest request, UriInfo uriInfo) {
        this.logSearchRequest(request, uriInfo, null);
    }

    public void logSearchRequest(HttpServletRequest request, UriInfo uriInfo, String payload) {
        if (this.isTraceEnabled()) {
            String requestUri = RestLogger.getRequestUri(uriInfo);
            String safeRequestUri = this.replacePatternBreakingCharacters(requestUri);
            String requestMethod = RestLogger.getRequestMethod(request);
            if (payload != null) {
                this.logger.trace(RX_SEARCH_REQUEST_WITH_PAYLOAD, new Object[]{requestMethod, safeRequestUri, RestLogger.trim(payload)});
            } else {
                this.logger.trace(RX_SEARCH_REQUEST, (Object)requestMethod, (Object)safeRequestUri);
            }
        }
    }

    private String replacePatternBreakingCharacters(String requestUri) {
        return requestUri.replaceAll("[\n\r\t]", "_");
    }

    public void logSearchResponse(Response response) {
        if (this.isTraceEnabled()) {
            int status = response.getStatus();
            String responsePayload = RestLogger.getResponsePayload(response);
            if (responsePayload.isEmpty()) {
                this.logger.trace(TX_SEARCH_RESPONSE, (Object)status);
            } else {
                this.logger.trace(TX_SEARCH_RESPONSE_WITH_PAYLOAD, (Object)status, (Object)responsePayload);
            }
        }
    }

    private static String getRequestMethod(HttpServletRequest request) {
        return request != null ? request.getMethod() : null;
    }

    private static String getRequestUri(UriInfo uriInfo) {
        URI requestUri = uriInfo != null ? uriInfo.getRequestUri() : null;
        return String.valueOf(requestUri);
    }

    private static String getResponsePayload(Response response) {
        Object entity = response.getEntity();
        return entity != null ? RestLogger.trim(entity.toString()) : "";
    }

    private static String trim(String payload) {
        int maxTraceMsgLength = SearchConfig.getMaxTraceMsgLength();
        if (payload.length() > maxTraceMsgLength) {
            int charsLeft = payload.length() - maxTraceMsgLength;
            return payload.substring(0, maxTraceMsgLength) + DOT_DOT_DOT + charsLeft + MORE;
        }
        return payload;
    }

    public void logSolrRequest(String msg, Object[] args) {
        if (this.isTraceEnabled()) {
            this.logger.trace(TX_SOLR_REQUEST + msg, this.trimAll(args));
        }
    }

    private List<String> trimAll(Object[] args) {
        ArrayList<String> trimmed = new ArrayList<String>(args.length);
        for (Object arg : args) {
            trimmed.add(RestLogger.trim(String.valueOf(arg)));
        }
        return trimmed;
    }

    public void logSolrResponse(SolrResponse response) {
        if (this.isTraceEnabled()) {
            this.logger.trace(RX_SOLR_RESPONSE_ELAPSED, (Object)response.getElapsedTime(), (Object)RestLogger.trim(response.getResponse().toString()));
        }
    }

    public void logSolrResponse(List<String> response) {
        if (this.isTraceEnabled()) {
            this.logger.trace(RX_SOLR_RESPONSE, (Object)RestLogger.trim(response.toString()));
        }
    }

    public void logSolrResponse(NamedList<Object> response) {
        if (this.isTraceEnabled()) {
            this.logger.trace(RX_SOLR_RESPONSE, (Object)RestLogger.trim(response.toString()));
        }
    }

    public void logSolrException(Exception e, String msg) {
        if (this.isTraceEnabled()) {
            this.logger.trace(RX_SOLR_EXCEPTION, (Object)msg, (Object)e.getMessage());
        }
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }
}

